/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.metadata;

import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface IPage<T>
extends Serializable {
    public List<OrderItem> orders();

    @Deprecated
    default public Map<Object, Object> condition() {
        return null;
    }

    default public boolean optimizeCountSql() {
        return true;
    }

    default public boolean isSearchCount() {
        return true;
    }

    default public long offset() {
        long current = this.getCurrent();
        if (current <= 1L) {
            return 0L;
        }
        return (current - 1L) * this.getSize();
    }

    default public Long maxLimit() {
        return null;
    }

    default public long getPages() {
        if (this.getSize() == 0L) {
            return 0L;
        }
        long pages = this.getTotal() / this.getSize();
        if (this.getTotal() % this.getSize() != 0L) {
            ++pages;
        }
        return pages;
    }

    default public IPage<T> setPages(long pages) {
        return this;
    }

    @Deprecated
    default public void hitCount(boolean hit) {
    }

    @Deprecated
    default public boolean isHitCount() {
        return false;
    }

    public List<T> getRecords();

    public IPage<T> setRecords(List<T> var1);

    public long getTotal();

    public IPage<T> setTotal(long var1);

    public long getSize();

    public IPage<T> setSize(long var1);

    public long getCurrent();

    public IPage<T> setCurrent(long var1);

    default public <R> IPage<R> convert(Function<? super T, ? extends R> mapper) {
        List collect = this.getRecords().stream().map(mapper).collect(Collectors.toList());
        return this.setRecords(collect);
    }

    default public String countId() {
        return null;
    }

    @Deprecated
    default public String cacheKey() {
        StringBuilder key = new StringBuilder();
        key.append(this.offset()).append(":").append(this.getSize());
        List<OrderItem> orders = this.orders();
        if (CollectionUtils.isNotEmpty(orders)) {
            for (OrderItem item : orders) {
                key.append(":").append(item.getColumn()).append(":").append(item.isAsc());
            }
        }
        return key.toString();
    }
}

