/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.toolkit;

import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.spi.CompatibleHelper;
import com.baomidou.mybatisplus.core.spi.CompatibleSet;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;

public final class SqlHelper {
    public static SqlSessionFactory FACTORY;

    @Deprecated
    public static SqlSession sqlSessionBatch(Class<?> clazz) {
        return SqlHelper.sqlSessionFactory(clazz).openSession(ExecutorType.BATCH);
    }

    @Deprecated
    public static SqlSessionFactory sqlSessionFactory(Class<?> clazz) {
        return GlobalConfigUtils.currentSessionFactory(clazz);
    }

    @Deprecated
    public static SqlSession sqlSession(Class<?> clazz) {
        return CompatibleHelper.getCompatibleSet().getSqlSession(GlobalConfigUtils.currentSessionFactory(clazz));
    }

    public static TableInfo table(Class<?> clazz) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(clazz);
        Assert.notNull((Object)tableInfo, (String)"Error: Cannot execute table Method, ClassGenericType not found.", (Object[])new Object[0]);
        return tableInfo;
    }

    public static boolean retBool(Integer result) {
        return null != result && result >= 1;
    }

    public static boolean retBool(Long result) {
        return null != result && result >= 1L;
    }

    public static boolean retBool(List<BatchResult> result) {
        return result != null && result.stream().flatMapToInt(r -> IntStream.of(r.getUpdateCounts())).allMatch(i -> i > 0 || i == -2);
    }

    public static long retCount(Long result) {
        return null == result ? 0L : result;
    }

    public static <E> E getObject(Log log, List<E> list) {
        return SqlHelper.getObject(() -> log, list);
    }

    public static <E> E getObject(Supplier<Log> supplier, List<E> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            int size = list.size();
            if (size > 1) {
                Log log = supplier.get();
                log.warn(String.format("Warn: execute Method There are  %s results.", size));
            }
            return list.get(0);
        }
        return null;
    }

    @Deprecated
    public static boolean executeBatch(Class<?> entityClass, Log log, Consumer<SqlSession> consumer) {
        return SqlHelper.executeBatch(SqlHelper.sqlSessionFactory(entityClass), log, consumer);
    }

    public static boolean executeBatch(SqlSessionFactory sqlSessionFactory, Log log, Consumer<SqlSession> consumer) {
        return CompatibleHelper.getCompatibleSet().executeBatch(sqlSessionFactory, log, consumer);
    }

    @Deprecated
    public static <E> boolean executeBatch(Class<?> entityClass, Log log, Collection<E> list, int batchSize, BiConsumer<SqlSession, E> consumer) {
        return SqlHelper.executeBatch(SqlHelper.sqlSessionFactory(entityClass), log, list, batchSize, consumer);
    }

    public static <E> boolean executeBatch(SqlSessionFactory sqlSessionFactory, Log log, Collection<E> list, int batchSize, BiConsumer<SqlSession, E> consumer) {
        Assert.isFalse((batchSize < 1 ? 1 : 0) != 0, (String)"batchSize must not be less than one", (Object[])new Object[0]);
        return !CollectionUtils.isEmpty(list) && SqlHelper.executeBatch(sqlSessionFactory, log, (SqlSession sqlSession) -> {
            int size = list.size();
            int idxLimit = Math.min(batchSize, size);
            int i = 1;
            for (Object element : list) {
                consumer.accept((SqlSession)sqlSession, element);
                if (i == idxLimit) {
                    sqlSession.flushStatements();
                    idxLimit = Math.min(idxLimit + batchSize, size);
                }
                ++i;
            }
        });
    }

    @Deprecated
    public static <E> boolean saveOrUpdateBatch(Class<?> entityClass, Class<?> mapper, Log log, Collection<E> list, int batchSize, BiPredicate<SqlSession, E> predicate, BiConsumer<SqlSession, E> consumer) {
        return SqlHelper.saveOrUpdateBatch(SqlHelper.sqlSessionFactory(entityClass), mapper, log, list, batchSize, predicate, consumer);
    }

    public static <E> boolean saveOrUpdateBatch(SqlSessionFactory sqlSessionFactory, Class<?> mapper, Log log, Collection<E> list, int batchSize, BiPredicate<SqlSession, E> predicate, BiConsumer<SqlSession, E> consumer) {
        String sqlStatement = SqlHelper.getSqlStatement(mapper, SqlMethod.INSERT_ONE);
        return SqlHelper.executeBatch(sqlSessionFactory, log, list, batchSize, (SqlSession sqlSession, E entity) -> {
            if (predicate.test((SqlSession)sqlSession, (Object)entity)) {
                sqlSession.insert(sqlStatement, entity);
            } else {
                consumer.accept((SqlSession)sqlSession, (Object)entity);
            }
        });
    }

    public static String getSqlStatement(Class<?> mapper, SqlMethod sqlMethod) {
        return mapper.getName() + "." + sqlMethod.getMethod();
    }

    public static <T, M extends BaseMapper<T>> M getMapper(Class<T> entityClass, SqlSession sqlSession) {
        CompatibleSet compatibleSet;
        Object bean;
        Assert.notNull(entityClass, (String)"entityClass can't be null!", (Object[])new Object[0]);
        TableInfo tableInfo = Optional.ofNullable(TableInfoHelper.getTableInfo(entityClass)).orElseThrow(() -> ExceptionUtils.mpe((String)"Can not find TableInfo from Class: \"%s\".", (Object[])new Object[]{entityClass.getName()}));
        Class mapperClass = ClassUtils.toClassConfident((String)tableInfo.getCurrentNamespace());
        if (CompatibleHelper.hasCompatibleSet() && (bean = (compatibleSet = CompatibleHelper.getCompatibleSet()).getBean(mapperClass)) != null) {
            return (M)((BaseMapper)bean);
        }
        return (M)((BaseMapper)tableInfo.getConfiguration().getMapper(mapperClass, sqlSession));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, R, M extends BaseMapper<T>> R execute(Class<T> entityClass, SFunction<M, R> sFunction) {
        SqlSession sqlSession = SqlHelper.sqlSession(entityClass);
        try {
            Object object = sFunction.apply(SqlHelper.getMapper(entityClass, sqlSession));
            return (R)object;
        }
        finally {
            CompatibleHelper.getCompatibleSet().closeSqlSession(sqlSession, GlobalConfigUtils.currentSessionFactory(entityClass));
        }
    }
}

