/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.builder;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.OutputFile;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.builder.Controller;
import com.baomidou.mybatisplus.generator.config.builder.Entity;
import com.baomidou.mybatisplus.generator.config.builder.Mapper;
import com.baomidou.mybatisplus.generator.config.builder.Service;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

class PathInfoHandler {
    private final Map<OutputFile, String> pathInfo = new HashMap<OutputFile, String>();
    private final String outputDir;
    private final PackageConfig packageConfig;

    PathInfoHandler(InjectionConfig injectionConfig, GlobalConfig globalConfig, StrategyConfig strategyConfig, PackageConfig packageConfig) {
        this.outputDir = globalConfig.getOutputDir();
        this.packageConfig = packageConfig;
        this.setDefaultPathInfo(injectionConfig, globalConfig, strategyConfig);
        Map<OutputFile, String> pathInfo = packageConfig.getPathInfo();
        if (CollectionUtils.isNotEmpty(pathInfo)) {
            this.pathInfo.putAll(pathInfo);
        }
    }

    private void setDefaultPathInfo(InjectionConfig injectionConfig, GlobalConfig globalConfig, StrategyConfig strategyConfig) {
        Controller controller;
        Service service;
        Mapper mapper;
        Entity entity = strategyConfig.entity();
        if (entity.isGenerate()) {
            this.putPathInfo(injectionConfig, globalConfig.isKotlin() ? entity.getKotlinTemplate() : entity.getJavaTemplate(), OutputFile.entity, "Entity");
        }
        if ((mapper = strategyConfig.mapper()).isGenerateMapper()) {
            this.putPathInfo(injectionConfig, mapper.getMapperTemplatePath(), OutputFile.mapper, "Mapper");
        }
        if (mapper.isGenerateMapperXml()) {
            this.putPathInfo(injectionConfig, mapper.getMapperXmlTemplatePath(), OutputFile.xml, "Xml");
        }
        if ((service = strategyConfig.service()).isGenerateService()) {
            this.putPathInfo(injectionConfig, service.getServiceTemplate(), OutputFile.service, "Service");
        }
        if (service.isGenerateServiceImpl()) {
            this.putPathInfo(injectionConfig, service.getServiceImplTemplate(), OutputFile.serviceImpl, "ServiceImpl");
        }
        if ((controller = strategyConfig.controller()).isGenerate()) {
            this.putPathInfo(injectionConfig, controller.getTemplatePath(), OutputFile.controller, "Controller");
        }
        this.putPathInfo(injectionConfig, OutputFile.parent, "Parent");
    }

    private void putPathInfo(InjectionConfig injectionConfig, String template, OutputFile outputFile, String module) {
        if (StringUtils.isNotBlank((CharSequence)template)) {
            this.putPathInfo(injectionConfig, outputFile, module);
        }
    }

    private void putPathInfo(InjectionConfig injectionConfig, OutputFile outputFile, String module) {
        this.pathInfo.putIfAbsent(outputFile, this.joinPath(this.outputDir, this.packageConfig.getPackageInfo(injectionConfig, module)));
    }

    private String joinPath(String parentDir, String packageName) {
        if (StringUtils.isBlank((CharSequence)parentDir)) {
            parentDir = System.getProperty("java.io.tmpdir");
        }
        if (!StringUtils.endsWith((String)parentDir, (String)File.separator)) {
            parentDir = parentDir + File.separator;
        }
        packageName = packageName.replaceAll("\\.", "\\" + File.separator);
        return parentDir + packageName;
    }

    public Map<OutputFile, String> getPathInfo() {
        return this.pathInfo;
    }
}

