/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway.graphql.inputs;

import com.braintreegateway.Request;
import com.braintreegateway.graphql.enums.Recommendations;
import com.braintreegateway.graphql.inputs.CustomerSessionInput;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomerRecommendationsInput
extends Request {
    private final String merchantAccountId;
    private final String sessionId;
    private final List<Recommendations> recommendations;
    private final CustomerSessionInput customer;

    @Override
    public Map<String, Object> toGraphQLVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("merchantAccountId", this.merchantAccountId);
        variables.put("sessionId", this.sessionId);
        variables.put("recommendations", this.recommendations);
        if (this.customer != null) {
            variables.put("customer", this.customer.toGraphQLVariables());
        }
        return variables;
    }

    private CustomerRecommendationsInput(Builder builder) {
        this.merchantAccountId = builder.merchantAccountId;
        this.sessionId = builder.sessionId;
        this.recommendations = builder.recommendations;
        this.customer = builder.customer;
    }

    public static Builder builder(String sessionId, List<Recommendations> recommendations) {
        return new Builder(sessionId, recommendations);
    }

    public static class Builder {
        private String merchantAccountId;
        private String sessionId;
        private List<Recommendations> recommendations;
        private CustomerSessionInput customer;

        public Builder(String sessionId, List<Recommendations> recommendations) {
            this.sessionId = sessionId;
            this.recommendations = recommendations;
        }

        public Builder merchantAccountId(String merchantAccountId) {
            this.merchantAccountId = merchantAccountId;
            return this;
        }

        public Builder customer(CustomerSessionInput customer) {
            this.customer = customer;
            return this;
        }

        public CustomerRecommendationsInput build() {
            return new CustomerRecommendationsInput(this);
        }
    }
}

