/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.BankAccountInstantVerificationJwt;
import com.braintreegateway.BankAccountInstantVerificationJwtRequest;
import com.braintreegateway.BraintreeGateway;
import com.braintreegateway.Configuration;
import com.braintreegateway.Result;
import com.braintreegateway.ValidationErrors;
import com.braintreegateway.exceptions.ServerException;
import com.braintreegateway.util.GraphQLClient;
import com.braintreegateway.util.Http;
import java.util.Map;

public class BankAccountInstantVerificationGateway {
    private final GraphQLClient graphQLClient;
    private static final String CREATE_JWT_MUTATION = "mutation CreateBankAccountInstantVerificationJwt($input: CreateBankAccountInstantVerificationJwtInput!) { createBankAccountInstantVerificationJwt(input: $input) {    jwt  }}";

    public BankAccountInstantVerificationGateway(BraintreeGateway gateway, Http http, Configuration configuration, GraphQLClient graphQLClient) {
        this.graphQLClient = graphQLClient;
    }

    public Result<BankAccountInstantVerificationJwt> createJwt(BankAccountInstantVerificationJwtRequest request) {
        Map<String, Object> response = this.graphQLClient.query(CREATE_JWT_MUTATION, request);
        ValidationErrors errors = GraphQLClient.getErrors(response);
        if (errors != null) {
            return new Result<BankAccountInstantVerificationJwt>(errors);
        }
        try {
            Map data = (Map)response.get("data");
            Map result = (Map)data.get("createBankAccountInstantVerificationJwt");
            String jwt = (String)result.get("jwt");
            BankAccountInstantVerificationJwt jwtObject = new BankAccountInstantVerificationJwt(jwt);
            return new Result<BankAccountInstantVerificationJwt>(jwtObject);
        }
        catch (ClassCastException | NullPointerException e) {
            throw new ServerException("Couldn't parse response: " + e.getMessage());
        }
    }
}

