/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy.generic.select_for_update;

import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.proxy.AbstractProxyManager;
import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import io.github.bucket4j.distributed.proxy.generic.select_for_update.LockAndGetResult;
import io.github.bucket4j.distributed.proxy.generic.select_for_update.SelectForUpdateBasedTransaction;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MutableBucketEntry;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.remote.Request;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractSelectForUpdateBasedProxyManager<K>
extends AbstractProxyManager<K> {
    private static final CommandResult RETRY_IN_THE_SCOPE_OF_NEW_TRANSACTION = CommandResult.success(Boolean.valueOf(true), 666);

    protected AbstractSelectForUpdateBasedProxyManager(ClientSideConfig clientSideConfig) {
        super(AbstractSelectForUpdateBasedProxyManager.injectTimeClock(clientSideConfig));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> CommandResult<T> execute(K key, Request<T> request) {
        CommandResult<T> result;
        SelectForUpdateBasedTransaction transaction = this.allocateTransaction(key);
        try {
            result = this.execute(request, transaction);
        }
        finally {
            transaction.release();
        }
        if (result == RETRY_IN_THE_SCOPE_OF_NEW_TRANSACTION && (result = this.execute(key, request)) == RETRY_IN_THE_SCOPE_OF_NEW_TRANSACTION) {
            throw new IllegalStateException();
        }
        return result;
    }

    @Override
    public boolean isAsyncModeSupported() {
        return false;
    }

    @Override
    public <T> CompletableFuture<CommandResult<T>> executeAsync(K key, Request<T> request) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected CompletableFuture<Void> removeAsync(Object key) {
        return null;
    }

    protected abstract SelectForUpdateBasedTransaction allocateTransaction(K var1);

    private <T> CommandResult<T> execute(Request<T> request, SelectForUpdateBasedTransaction transaction) {
        LockAndGetResult lockResult;
        RemoteCommand<T> command = request.getCommand();
        transaction.begin();
        try {
            lockResult = transaction.tryLockAndGet();
        }
        catch (Throwable t) {
            transaction.rollback();
            throw new BucketExceptions.BucketExecutionException(t);
        }
        if (!lockResult.isLocked()) {
            try {
                if (transaction.tryInsertEmptyData()) {
                    transaction.commit();
                } else {
                    transaction.rollback();
                }
                return RETRY_IN_THE_SCOPE_OF_NEW_TRANSACTION;
            }
            catch (Throwable t) {
                transaction.rollback();
                throw new BucketExceptions.BucketExecutionException(t);
            }
        }
        byte[] persistedDataOnBeginOfTransaction = lockResult.getData();
        if (persistedDataOnBeginOfTransaction == null && !request.getCommand().isInitializationCommand()) {
            transaction.rollback();
            return CommandResult.bucketNotFound();
        }
        try {
            MutableBucketEntry entry = new MutableBucketEntry(persistedDataOnBeginOfTransaction);
            CommandResult<T> result = command.execute(entry, super.getClientSideTime());
            if (entry.isStateModified()) {
                RemoteBucketState modifiedState = entry.get();
                byte[] bytes = entry.getStateBytes(request.getBackwardCompatibilityVersion());
                transaction.update(bytes, modifiedState);
            }
            transaction.commit();
            return result;
        }
        catch (Throwable t) {
            transaction.rollback();
            throw new BucketExceptions.BucketExecutionException(t);
        }
    }

    private static ClientSideConfig injectTimeClock(ClientSideConfig clientSideConfig) {
        if (clientSideConfig.getClientSideClock().isPresent()) {
            return clientSideConfig;
        }
        return clientSideConfig.withClientClock(TimeMeter.SYSTEM_MILLISECONDS);
    }
}

