/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import io.github.bucket4j.caffeine.Bucket4jCaffeine;
import io.github.bucket4j.distributed.ExpirationAfterWriteStrategy;
import io.github.bucket4j.distributed.proxy.AbstractProxyManager;
import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MutableBucketEntry;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.remote.Request;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public class CaffeineProxyManager<K>
extends AbstractProxyManager<K> {
    private final Cache<K, RemoteBucketState> cache;

    CaffeineProxyManager(Bucket4jCaffeine.CaffeineProxyManagerBuilder<K> builder) {
        super(builder.getClientSideConfig());
        this.cache = builder.cacheBuilder.expireAfter(new Expiry<K, RemoteBucketState>(){
            private final ExpirationAfterWriteStrategy expiration;
            {
                this.expiration = CaffeineProxyManager.this.getClientSideConfig().getExpirationAfterWriteStrategy().orElse(ExpirationAfterWriteStrategy.none());
            }

            public long expireAfterCreate(K key, RemoteBucketState bucketState, long currentTime) {
                long ttlNanos = this.expiration.calculateTimeToLiveMillis(bucketState, CaffeineProxyManager.this.currentTimeNanos()) * 1000000L;
                return ttlNanos < 0L ? Long.MAX_VALUE : ttlNanos;
            }

            public long expireAfterUpdate(K key, RemoteBucketState bucketState, long currentTime, long currentDuration) {
                long ttlNanos = this.expiration.calculateTimeToLiveMillis(bucketState, CaffeineProxyManager.this.currentTimeNanos()) * 1000000L;
                return ttlNanos < 0L ? Long.MAX_VALUE : ttlNanos;
            }

            public long expireAfterRead(K key, RemoteBucketState bucketState, long currentTime, long currentDuration) {
                long ttlNanos = this.expiration.calculateTimeToLiveMillis(bucketState, CaffeineProxyManager.this.currentTimeNanos()) * 1000000L;
                return ttlNanos < 0L ? Long.MAX_VALUE : ttlNanos;
            }
        }).build();
    }

    @Deprecated
    public CaffeineProxyManager(Caffeine<? super K, ? super RemoteBucketState> builder, Duration keepAfterRefillDuration) {
        this(builder, keepAfterRefillDuration, ClientSideConfig.getDefault());
    }

    @Deprecated
    public CaffeineProxyManager(Caffeine<? super K, ? super RemoteBucketState> builder, final Duration keepAfterRefillDuration, ClientSideConfig clientSideConfig) {
        super(clientSideConfig);
        this.cache = builder.expireAfter(new Expiry<K, RemoteBucketState>(){

            public long expireAfterCreate(K key, RemoteBucketState bucketState, long currentTime) {
                long currentTimeNanos = CaffeineProxyManager.this.currentTimeNanos();
                long nanosToFullRefill = bucketState.calculateFullRefillingTime(currentTimeNanos);
                return nanosToFullRefill + keepAfterRefillDuration.toNanos();
            }

            public long expireAfterUpdate(K key, RemoteBucketState bucketState, long currentTime, long currentDuration) {
                long currentTimeNanos = CaffeineProxyManager.this.currentTimeNanos();
                long nanosToFullRefill = bucketState.calculateFullRefillingTime(currentTimeNanos);
                return nanosToFullRefill + keepAfterRefillDuration.toNanos();
            }

            public long expireAfterRead(K key, RemoteBucketState bucketState, long currentTime, long currentDuration) {
                long currentTimeNanos = CaffeineProxyManager.this.currentTimeNanos();
                long nanosToFullRefill = bucketState.calculateFullRefillingTime(currentTimeNanos);
                return nanosToFullRefill + keepAfterRefillDuration.toNanos();
            }
        }).build();
    }

    public boolean isExpireAfterWriteSupported() {
        return true;
    }

    public Cache<K, RemoteBucketState> getCache() {
        return this.cache;
    }

    public <T> CommandResult<T> execute(K key, Request<T> request) {
        CommandResult[] resultHolder = new CommandResult[1];
        this.cache.asMap().compute(key, (k, previousState) -> {
            Long clientSideTime = request.getClientSideTime();
            long timeNanos = clientSideTime != null ? clientSideTime : System.currentTimeMillis() * 1000000L;
            MutableBucketEntry entryWrapper = new MutableBucketEntry(previousState == null ? null : previousState.copy());
            resultHolder[0] = request.getCommand().execute(entryWrapper, timeNanos);
            return entryWrapper.exists() ? entryWrapper.get() : null;
        });
        return resultHolder[0];
    }

    public boolean isAsyncModeSupported() {
        return true;
    }

    public <T> CompletableFuture<CommandResult<T>> executeAsync(K key, Request<T> request) {
        CommandResult<T> result = this.execute(key, request);
        return CompletableFuture.completedFuture(result);
    }

    public void removeProxy(K key) {
        this.cache.asMap().remove(key);
    }

    protected CompletableFuture<Void> removeAsync(K key) {
        this.cache.asMap().remove(key);
        return CompletableFuture.completedFuture(null);
    }
}

