/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.annotations;

import com.c4_soft.springaddons.security.oauth2.test.annotations.AbstractAnnotatedAuthenticationBuilder;
import com.c4_soft.springaddons.security.oauth2.test.annotations.Claims;
import com.c4_soft.springaddons.security.oauth2.test.annotations.OpenIdClaims;
import com.c4_soft.springaddons.security.oauth2.test.annotations.StringClaim;
import com.c4_soft.springaddons.security.oidc.OpenidClaimSet;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.springframework.core.annotation.AliasFor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.test.context.support.TestExecutionEvent;
import org.springframework.security.test.context.support.WithSecurityContext;
import reactor.core.publisher.Mono;

@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Inherited
@Documented
@WithSecurityContext(factory=JwtAuthenticationTokenFactory.class)
public @interface WithMockJwtAuth {
    @AliasFor(value="claims")
    public OpenIdClaims value() default @OpenIdClaims;

    @AliasFor(value="value")
    public OpenIdClaims claims() default @OpenIdClaims;

    public String tokenString() default "machin.truc.chose";

    public Claims headers() default @Claims(stringClaims={@StringClaim(name="alg", value="none")});

    @AliasFor(annotation=WithSecurityContext.class)
    public TestExecutionEvent setupBefore() default TestExecutionEvent.TEST_METHOD;

    public static final class JwtAuthenticationTokenFactory
    extends AbstractAnnotatedAuthenticationBuilder<WithMockJwtAuth, AbstractAuthenticationToken> {
        private final Optional<Converter<Jwt, ? extends AbstractAuthenticationToken>> jwtAuthenticationConverter;
        private final Optional<Converter<Jwt, ? extends Mono<? extends AbstractAuthenticationToken>>> reactiveJwtAuthenticationConverter;

        @Override
        public AbstractAuthenticationToken authentication(WithMockJwtAuth annotation) {
            OpenidClaimSet token = super.claims(annotation.claims()).build();
            Jwt jwt = new Jwt(annotation.tokenString(), token.getIssuedAt(), token.getExpiresAt(), (Map)Claims.Token.of(annotation.headers()), (Map)token);
            return this.jwtAuthenticationConverter.map(c -> {
                AbstractAuthenticationToken auth = (AbstractAuthenticationToken)c.convert((Object)jwt);
                return auth;
            }).orElseGet(() -> this.reactiveJwtAuthenticationConverter.map(c -> {
                AbstractAuthenticationToken auth = (AbstractAuthenticationToken)((Mono)c.convert((Object)jwt)).block();
                return auth;
            }).orElseGet(() -> {
                JwtAuthenticationConverter converter = new JwtAuthenticationConverter();
                converter.setPrincipalClaimName(annotation.claims().usernameClaim());
                return converter.convert(jwt);
            }));
        }

        @Generated
        public JwtAuthenticationTokenFactory(Optional<Converter<Jwt, ? extends AbstractAuthenticationToken>> jwtAuthenticationConverter, Optional<Converter<Jwt, ? extends Mono<? extends AbstractAuthenticationToken>>> reactiveJwtAuthenticationConverter) {
            this.jwtAuthenticationConverter = jwtAuthenticationConverter;
            this.reactiveJwtAuthenticationConverter = reactiveJwtAuthenticationConverter;
        }
    }
}

