/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.webflux;

import com.c4_soft.springaddons.security.oauth2.test.webflux.WebTestClientProperties;
import com.c4_soft.springaddons.security.oidc.starter.properties.Csrf;
import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcProperties;
import java.nio.charset.Charset;
import org.springframework.http.MediaType;
import org.springframework.security.test.web.reactive.server.SecurityMockServerConfigurers;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.test.web.reactive.server.WebTestClientConfigurer;

public class WebTestClientSupport {
    private MediaType mediaType;
    private Charset charset;
    private WebTestClient delegate;

    public WebTestClientSupport(WebTestClientProperties webTestClientProperties, WebTestClient webTestClient, SpringAddonsOidcProperties addonsProperties) {
        this.mediaType = MediaType.valueOf((String)webTestClientProperties.getDefaultMediaType());
        this.charset = Charset.forName(webTestClientProperties.getDefaultCharset());
        this.delegate = webTestClient;
        this.setCsrf(!addonsProperties.getResourceserver().getCsrf().equals((Object)Csrf.DISABLE));
    }

    public WebTestClientSupport setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public WebTestClientSupport setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public WebTestClient.ResponseSpec get(MediaType accept, String uriTemplate, Object ... uriVars) {
        return this.delegate.get().uri(uriTemplate, uriVars).accept(new MediaType[]{accept}).exchange();
    }

    public WebTestClient.ResponseSpec get(String uriTemplate, Object ... uriVars) {
        return this.get(new MediaType(this.mediaType, this.charset), uriTemplate, uriVars);
    }

    public <T> WebTestClient.ResponseSpec post(T payload, MediaType contentType, Charset charset, MediaType accept, String uriTemplate, Object ... uriVars) {
        return ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.delegate.post().uri(uriTemplate, uriVars)).accept(new MediaType[]{accept})).contentType(new MediaType(contentType, charset)).bodyValue(payload).exchange();
    }

    public <T> WebTestClient.ResponseSpec post(T payload, String uriTemplate, Object ... uriVars) {
        return this.post(payload, this.mediaType, this.charset, this.mediaType, uriTemplate, uriVars);
    }

    public <T> WebTestClient.ResponseSpec put(T payload, MediaType contentType, Charset charset, String uriTemplate, Object ... uriVars) {
        return ((WebTestClient.RequestBodySpec)this.delegate.put().uri(uriTemplate, uriVars)).contentType(new MediaType(contentType, charset)).bodyValue(payload).exchange();
    }

    public <T> WebTestClient.ResponseSpec put(T payload, String uriTemplate, Object ... uriVars) {
        return this.put(payload, this.mediaType, this.charset, uriTemplate, uriVars);
    }

    public <T> WebTestClient.ResponseSpec patch(T payload, MediaType contentType, Charset charset, String uriTemplate, Object ... uriVars) {
        return ((WebTestClient.RequestBodySpec)this.delegate.patch().uri(uriTemplate, uriVars)).contentType(new MediaType(contentType, charset)).bodyValue(payload).exchange();
    }

    public <T> WebTestClient.ResponseSpec patch(T payload, String uriTemplate, Object ... uriVars) {
        return this.patch(payload, this.mediaType, this.charset, uriTemplate, uriVars);
    }

    public WebTestClient.ResponseSpec delete(String uriTemplate, Object ... uriVars) {
        return this.delegate.delete().uri(uriTemplate, uriVars).exchange();
    }

    public WebTestClientSupport mutateWith(WebTestClientConfigurer configurer) {
        this.delegate = this.delegate.mutateWith(configurer);
        return this;
    }

    public WebTestClientSupport setCsrf(boolean isCsrf) {
        this.delegate.mutateWith((WebTestClientConfigurer)SecurityMockServerConfigurers.csrf());
        return this;
    }
}

