/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.webmvc;

import com.c4_soft.springaddons.security.oauth2.test.AuthenticationFactoriesTestConf;
import com.c4_soft.springaddons.security.oauth2.test.webflux.AddonsWebfluxTestConf;
import com.c4_soft.springaddons.security.oauth2.test.webmvc.MockMvcProperties;
import com.c4_soft.springaddons.security.oauth2.test.webmvc.MockMvcSupport;
import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcProperties;
import com.c4_soft.springaddons.test.support.web.SerializationHelper;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.security.authentication.AuthenticationManagerResolver;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.test.web.servlet.MockMvc;

@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@AutoConfiguration
@ImportAutoConfiguration(classes={MockMvcProperties.class, AuthenticationFactoriesTestConf.class}, exclude={AddonsWebfluxTestConf.class})
public class AddonsWebmvcTestConf {
    @MockBean
    JwtDecoder jwtDecoder;
    @MockBean
    AuthenticationManagerResolver<HttpServletRequest> jwtIssuerAuthenticationManagerResolver;
    @MockBean
    OpaqueTokenIntrospector introspector;
    @MockBean
    OAuth2AuthorizedClientService oAuth2AuthorizedClientService;

    @ConditionalOnMissingBean
    @Bean
    InMemoryClientRegistrationRepository clientRegistrationRepository() {
        InMemoryClientRegistrationRepository clientRegistrationRepository = (InMemoryClientRegistrationRepository)Mockito.mock(InMemoryClientRegistrationRepository.class);
        Mockito.when((Object)clientRegistrationRepository.iterator()).thenReturn(new ArrayList().iterator());
        Mockito.when((Object)clientRegistrationRepository.spliterator()).thenReturn(new ArrayList().spliterator());
        Mockito.when((Object)clientRegistrationRepository.findByRegistrationId(ArgumentMatchers.anyString())).thenAnswer(invocation -> ClientRegistration.withRegistrationId((String)((String)invocation.getArgument(0))).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).clientId((String)invocation.getArgument(0)).redirectUri("http://localhost:8080/oauth2/code/%s".formatted(invocation.getArgument(0).toString())).authorizationUri("https://localhost:8443/auth").tokenUri("https://localhost:8443/token").build());
        return clientRegistrationRepository;
    }

    @Bean
    SerializationHelper serializationHelper(ObjectFactory<HttpMessageConverters> messageConverters) {
        return new SerializationHelper(messageConverters);
    }

    @Bean
    @Scope(value="prototype")
    MockMvcSupport mockMvcSupport(MockMvc mockMvc, SerializationHelper serializationHelper, MockMvcProperties mockMvcProperties, ServerProperties serverProperties, SpringAddonsOidcProperties addonsProperties) {
        return new MockMvcSupport(mockMvc, serializationHelper, mockMvcProperties, serverProperties, addonsProperties);
    }
}

