/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.reactive.client;

import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.StreamSupport;
import org.springframework.security.oauth2.client.AuthorizationCodeReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.ClientCredentialsReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.DelegatingReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizationContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.RefreshTokenReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.endpoint.ReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.WebClientReactiveClientCredentialsTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.WebClientReactiveRefreshTokenTokenResponseClient;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.InMemoryReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Mono;

public final class PerRegistrationReactiveOAuth2AuthorizedClientProvider
implements ReactiveOAuth2AuthorizedClientProvider {
    private final Map<String, DelegatingReactiveOAuth2AuthorizedClientProvider> providersByRegistrationId = new ConcurrentHashMap<String, DelegatingReactiveOAuth2AuthorizedClientProvider>();
    private final Map<String, List<ReactiveOAuth2AuthorizedClientProvider>> customProvidersByRegistrationId;
    private final SpringAddonsOidcProperties addonsProperties;

    public PerRegistrationReactiveOAuth2AuthorizedClientProvider(InMemoryReactiveClientRegistrationRepository clientRegistrationRepo, SpringAddonsOidcProperties addonsProperties, Map<String, List<ReactiveOAuth2AuthorizedClientProvider>> customProvidersByRegistrationId) {
        this.customProvidersByRegistrationId = customProvidersByRegistrationId;
        this.addonsProperties = addonsProperties;
        StreamSupport.stream(clientRegistrationRepo.spliterator(), false).forEach(reg -> {
            DelegatingReactiveOAuth2AuthorizedClientProvider delegate = new DelegatingReactiveOAuth2AuthorizedClientProvider(this.getProvidersFor((ClientRegistration)reg, addonsProperties));
            this.providersByRegistrationId.put(reg.getRegistrationId(), delegate);
        });
    }

    public Mono<OAuth2AuthorizedClient> authorize(OAuth2AuthorizationContext context) {
        if (context == null) {
            return null;
        }
        ClientRegistration registration = context.getClientRegistration();
        if (!this.providersByRegistrationId.containsKey(registration.getRegistrationId())) {
            DelegatingReactiveOAuth2AuthorizedClientProvider delegate = new DelegatingReactiveOAuth2AuthorizedClientProvider(this.getProvidersFor(registration, this.addonsProperties));
            this.providersByRegistrationId.put(registration.getRegistrationId(), delegate);
        }
        return this.providersByRegistrationId.get(registration.getRegistrationId()).authorize(context);
    }

    private List<ReactiveOAuth2AuthorizedClientProvider> getProvidersFor(ClientRegistration registration, SpringAddonsOidcProperties addonsProperties) {
        ArrayList<ReactiveOAuth2AuthorizedClientProvider> providers = new ArrayList<ReactiveOAuth2AuthorizedClientProvider>(this.customProvidersByRegistrationId.getOrDefault(registration.getRegistrationId(), List.of()));
        if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)registration.getAuthorizationGrantType())) {
            providers.add((ReactiveOAuth2AuthorizedClientProvider)new AuthorizationCodeReactiveOAuth2AuthorizedClientProvider());
            if (registration.getScopes().contains("offline_access")) {
                providers.add((ReactiveOAuth2AuthorizedClientProvider)this.createRefreshTokenProvider(registration, addonsProperties));
            }
        } else if (AuthorizationGrantType.CLIENT_CREDENTIALS.equals((Object)registration.getAuthorizationGrantType())) {
            providers.add((ReactiveOAuth2AuthorizedClientProvider)this.createClientCredentialsProvider(registration, addonsProperties));
        }
        return providers;
    }

    private ClientCredentialsReactiveOAuth2AuthorizedClientProvider createClientCredentialsProvider(ClientRegistration registration, SpringAddonsOidcProperties addonsProperties) {
        ClientCredentialsReactiveOAuth2AuthorizedClientProvider provider = new ClientCredentialsReactiveOAuth2AuthorizedClientProvider();
        MultiValueMap<String, String> extraParameters = addonsProperties.getClient().getExtraTokenParameters(registration.getRegistrationId());
        if (extraParameters.size() == 0) {
            return provider;
        }
        WebClientReactiveClientCredentialsTokenResponseClient responseClient = new WebClientReactiveClientCredentialsTokenResponseClient();
        responseClient.addParametersConverter(source -> extraParameters);
        provider.setAccessTokenResponseClient((ReactiveOAuth2AccessTokenResponseClient)responseClient);
        return provider;
    }

    private RefreshTokenReactiveOAuth2AuthorizedClientProvider createRefreshTokenProvider(ClientRegistration registration, SpringAddonsOidcProperties addonsProperties) {
        RefreshTokenReactiveOAuth2AuthorizedClientProvider provider = new RefreshTokenReactiveOAuth2AuthorizedClientProvider();
        MultiValueMap<String, String> extraParameters = addonsProperties.getClient().getExtraTokenParameters(registration.getRegistrationId());
        if (extraParameters.size() == 0) {
            return provider;
        }
        WebClientReactiveRefreshTokenTokenResponseClient responseClient = new WebClientReactiveRefreshTokenTokenResponseClient();
        responseClient.addParametersConverter(source -> extraParameters);
        provider.setAccessTokenResponseClient((ReactiveOAuth2AccessTokenResponseClient)responseClient);
        return provider;
    }
}

