/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.junitbenchmarks.db;

import com.carrotsearch.junitbenchmarks.db.DbConsumer;
import com.carrotsearch.junitbenchmarks.db.GeneratorUtils;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public final class MethodChartGenerator {
    private String clazzName;
    private String filePrefix;
    private DbConsumer consumer;
    double min = Double.NaN;
    double max = Double.NaN;

    public MethodChartGenerator(String filePrefix, String clazzName, DbConsumer consumer) {
        this.clazzName = clazzName;
        this.filePrefix = filePrefix;
        this.consumer = consumer;
    }

    public void generate() throws Exception {
        String jsonFileName = this.filePrefix + ".json";
        String htmlFileName = this.filePrefix + ".html";
        String template = this.consumer.getMethodHtmlTemplate();
        template = GeneratorUtils.replaceToken(template, "CLASSNAME", this.clazzName);
        template = GeneratorUtils.replaceToken(template, "MethodChartGenerator.json", new File(jsonFileName).getName());
        template = GeneratorUtils.replaceToken(template, "/*MINMAX*/", GeneratorUtils.getMinMax(this.min, this.max));
        template = GeneratorUtils.replaceToken(template, "PROPERTIES", GeneratorUtils.getProperties(this.consumer));
        GeneratorUtils.save(htmlFileName, template);
        GeneratorUtils.save(jsonFileName, this.getData());
    }

    private String getData() throws SQLException {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("{\n");
        PreparedStatement s = this.consumer.getConnection().prepareStatement(this.consumer.getMethodChartResultsQuery());
        s.setInt(1, this.consumer.getRunId());
        s.setString(2, this.clazzName);
        ResultSet rs = s.executeQuery();
        buf.append("\"cols\": [\n");
        ResultSetMetaData metaData = rs.getMetaData();
        for (i = 1; i <= metaData.getColumnCount(); ++i) {
            String colLabel = metaData.getColumnLabel(i);
            String type = GeneratorUtils.getMappedType(metaData.getColumnType(i));
            buf.append("{\"label\": \"");
            buf.append(colLabel);
            buf.append("\", \"type\": \"");
            buf.append(type);
            buf.append("\"}");
            if (i != metaData.getColumnCount()) {
                buf.append(",");
            }
            buf.append('\n');
        }
        buf.append("],\n");
        buf.append("\"rows\": [\n");
        while (rs.next()) {
            buf.append("{\"c\": [");
            for (i = 1; i <= metaData.getColumnCount(); ++i) {
                if (i > 1) {
                    buf.append(", ");
                }
                Object value = GeneratorUtils.formatValue(metaData.getColumnType(i), rs.getObject(i));
                buf.append("{\"v\": ");
                buf.append(value.toString());
                buf.append("}");
            }
            buf.append("]}");
            if (!rs.isLast()) {
                buf.append(",");
            }
            buf.append('\n');
        }
        buf.append("]}\n");
        rs.close();
        return buf.toString();
    }
}

