/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.junitbenchmarks.mysql;

import com.carrotsearch.junitbenchmarks.db.DbConsumer;
import com.mysql.jdbc.jdbc2.optional.MysqlDataSource;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;

public final class MySQLConsumer
extends DbConsumer {
    private String dbUrl;

    public MySQLConsumer() {
        this(MySQLConsumer.getDefaultServerLocation());
    }

    public MySQLConsumer(String dbUrl) {
        this(dbUrl, MySQLConsumer.getDefaultChartsDir(), MySQLConsumer.getDefaultCustomKey());
    }

    public MySQLConsumer(String dbUrl, File chartsDir, String customKeyValue) {
        super(chartsDir, customKeyValue);
        this.dbUrl = dbUrl;
        try {
            this.checkSchema();
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot initialize MySQL database.", e);
        }
    }

    private static String getDefaultServerLocation() {
        String dbPath = System.getProperty("jub.mysql.url");
        if (dbPath != null && !dbPath.trim().equals("")) {
            return dbPath;
        }
        throw new IllegalArgumentException("Missing global property: jub.mysql.url");
    }

    @Override
    protected Connection createConnection() throws SQLException {
        MysqlDataSource ds = new MysqlDataSource();
        ds.setURL(this.dbUrl);
        Connection results = ds.getConnection();
        results.setAutoCommit(false);
        return results;
    }

    @Override
    public String getMethodChartResultsQuery() {
        return MySQLConsumer.getResource(MySQLConsumer.class, "method-chart-results.sql");
    }

    @Override
    public String getMethodChartPropertiesQuery() {
        return MySQLConsumer.getResource(MySQLConsumer.class, "method-chart-properties.sql");
    }

    @Override
    protected String getCreateRunsSql() {
        return MySQLConsumer.getResource(MySQLConsumer.class, "000-create-runs.sql");
    }

    @Override
    protected String getCreateTestsSql() {
        return MySQLConsumer.getResource(MySQLConsumer.class, "001-create-tests.sql");
    }

    @Override
    protected String getNewRunSql() {
        return MySQLConsumer.getResource(MySQLConsumer.class, "002-new-run.sql");
    }

    @Override
    protected String getTestInsertSql() {
        return MySQLConsumer.getResource(MySQLConsumer.class, "003-new-result.sql");
    }

    @Override
    protected String getCreateDbVersionSql() {
        return MySQLConsumer.getResource(MySQLConsumer.class, "004-create-dbversion.sql");
    }

    @Override
    protected String getAddCustomKeySql() {
        return MySQLConsumer.getResource(MySQLConsumer.class, "005-add-custom-key.sql");
    }
}

