/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.SealableList;
import com.cedarsoftware.util.SealableNavigableSet;
import com.cedarsoftware.util.SealableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Supplier;

public class SealableNavigableMap<K, V>
implements NavigableMap<K, V> {
    private final NavigableMap<K, V> navMap;
    private final transient Supplier<Boolean> sealedSupplier;

    public SealableNavigableMap(Supplier<Boolean> sealedSupplier) {
        this.sealedSupplier = sealedSupplier;
        this.navMap = new ConcurrentSkipListMap();
    }

    public SealableNavigableMap(SortedMap<K, V> map, Supplier<Boolean> sealedSupplier) {
        this.sealedSupplier = sealedSupplier;
        this.navMap = new ConcurrentSkipListMap<K, V>(map);
    }

    public SealableNavigableMap(NavigableMap<K, V> map, Supplier<Boolean> sealedSupplier) {
        this.sealedSupplier = sealedSupplier;
        this.navMap = map;
    }

    private void throwIfSealed() {
        if (this.sealedSupplier.get().booleanValue()) {
            throw new UnsupportedOperationException("This map has been sealed and is now immutable");
        }
    }

    @Override
    public boolean equals(Object o) {
        return this.navMap.equals(o);
    }

    @Override
    public int hashCode() {
        return this.navMap.hashCode();
    }

    public String toString() {
        return this.navMap.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.navMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.navMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.navMap.containsValue(value);
    }

    @Override
    public int size() {
        return this.navMap.size();
    }

    @Override
    public V get(Object key) {
        return this.navMap.get(key);
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.navMap.comparator();
    }

    @Override
    public K firstKey() {
        return this.navMap.firstKey();
    }

    @Override
    public K lastKey() {
        return this.navMap.lastKey();
    }

    @Override
    public Set<K> keySet() {
        return new SealableSet(this.navMap.keySet(), this.sealedSupplier);
    }

    @Override
    public Collection<V> values() {
        return new SealableList(new ArrayList(this.navMap.values()), this.sealedSupplier);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new SealableSet(this.navMap.entrySet(), this.sealedSupplier);
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        return this.navMap.lowerEntry(key);
    }

    @Override
    public K lowerKey(K key) {
        return this.navMap.lowerKey(key);
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        return this.navMap.floorEntry(key);
    }

    @Override
    public K floorKey(K key) {
        return this.navMap.floorKey(key);
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        return this.navMap.ceilingEntry(key);
    }

    @Override
    public K ceilingKey(K key) {
        return this.navMap.ceilingKey(key);
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        return this.navMap.higherEntry(key);
    }

    @Override
    public K higherKey(K key) {
        return this.navMap.higherKey(key);
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return this.navMap.firstEntry();
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return this.navMap.lastEntry();
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        return new SealableNavigableMap<K, V>(this.navMap.descendingMap(), this.sealedSupplier);
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return new SealableNavigableSet<K>(this.navMap.navigableKeySet(), this.sealedSupplier);
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return new SealableNavigableSet<K>(this.navMap.descendingKeySet(), this.sealedSupplier);
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap(fromKey, true, toKey, false);
    }

    @Override
    public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return new SealableNavigableMap<K, V>(this.navMap.subMap(fromKey, fromInclusive, toKey, toInclusive), this.sealedSupplier);
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return this.headMap(toKey, false);
    }

    @Override
    public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        return new SealableNavigableMap<K, V>(this.navMap.headMap(toKey, inclusive), this.sealedSupplier);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return this.tailMap(fromKey, true);
    }

    @Override
    public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        return new SealableNavigableMap<K, V>(this.navMap.tailMap(fromKey, inclusive), this.sealedSupplier);
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        this.throwIfSealed();
        return this.navMap.pollFirstEntry();
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        this.throwIfSealed();
        return this.navMap.pollLastEntry();
    }

    @Override
    public V put(K key, V value) {
        this.throwIfSealed();
        return this.navMap.put(key, value);
    }

    @Override
    public V remove(Object key) {
        this.throwIfSealed();
        return this.navMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.throwIfSealed();
        this.navMap.putAll(m);
    }

    @Override
    public void clear() {
        this.throwIfSealed();
        this.navMap.clear();
    }
}

