/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.CollectionUtilities;
import com.cedarsoftware.util.ConcurrentHashMapNullSafe;
import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.Converter;
import com.cedarsoftware.util.ExceptionUtilities;
import com.cedarsoftware.util.LRUCache;
import com.cedarsoftware.util.ReflectionUtils;
import com.cedarsoftware.util.Unsafe;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class ClassUtilities {
    private static final Set<Class<?>> prims = new HashSet();
    private static final Map<Class<?>, Class<?>> primitiveToWrapper = new HashMap(20, 0.8f);
    private static final Map<String, Class<?>> nameToClass = new ConcurrentHashMap();
    private static final Map<Class<?>, Class<?>> wrapperMap = new HashMap();
    private static final ConcurrentHashMapNullSafe<Class<?>, ClassLoader> osgiClassLoaders = new ConcurrentHashMapNullSafe();
    private static final ClassLoader SYSTEM_LOADER = ClassLoader.getSystemClassLoader();
    private static volatile boolean useUnsafe = false;
    private static volatile Unsafe unsafe;
    private static final Map<Class<?>, Supplier<Object>> DIRECT_CLASS_MAPPING;
    private static final Map<Class<?>, Supplier<Object>> ASSIGNABLE_CLASS_MAPPING;
    private static volatile Map<Class<?>, Set<Class<?>>> SUPER_TYPES_CACHE;
    private static volatile Map<Map.Entry<Class<?>, Class<?>>, Integer> CLASS_DISTANCE_CACHE;
    private static final int BUFFER_SIZE = 65536;

    public static void setSuperTypesCache(Map<Class<?>, Set<Class<?>>> cache) {
        SUPER_TYPES_CACHE = cache;
    }

    public static void setClassDistanceCache(Map<Map.Entry<Class<?>, Class<?>>, Integer> cache) {
        CLASS_DISTANCE_CACHE = cache;
    }

    public static void addPermanentClassAlias(Class<?> clazz, String alias) {
        nameToClass.put(alias, clazz);
    }

    public static void removePermanentClassAlias(String alias) {
        nameToClass.remove(alias);
    }

    public static int computeInheritanceDistance(Class<?> source, Class<?> destination) {
        if (source == null || destination == null) {
            return -1;
        }
        if (source.equals(destination)) {
            return 0;
        }
        AbstractMap.SimpleImmutableEntry key = new AbstractMap.SimpleImmutableEntry(source, destination);
        return CLASS_DISTANCE_CACHE.computeIfAbsent(key, k -> {
            if (source.isPrimitive()) {
                if (destination.isPrimitive()) {
                    return -1;
                }
                if (!ClassUtilities.isPrimitive(destination)) {
                    return -1;
                }
                return ClassUtilities.comparePrimitiveToWrapper(destination, source);
            }
            if (destination.isPrimitive()) {
                if (!ClassUtilities.isPrimitive(source)) {
                    return -1;
                }
                return ClassUtilities.comparePrimitiveToWrapper(source, destination);
            }
            LinkedList queue = new LinkedList();
            IdentityHashMap visited = new IdentityHashMap();
            queue.add(source);
            visited.put(source, Boolean.TRUE);
            int distance = 0;
            while (!queue.isEmpty()) {
                int levelSize = queue.size();
                ++distance;
                for (int i = 0; i < levelSize; ++i) {
                    Class current = (Class)queue.poll();
                    Class sup = current.getSuperclass();
                    if (sup != null) {
                        if (sup.equals(destination)) {
                            return distance;
                        }
                        if (!visited.containsKey(sup)) {
                            queue.add(sup);
                            visited.put(sup, Boolean.TRUE);
                        }
                    }
                    for (Class<?> iface : current.getInterfaces()) {
                        if (iface.equals(destination)) {
                            return distance;
                        }
                        if (visited.containsKey(iface)) continue;
                        queue.add(iface);
                        visited.put(iface, Boolean.TRUE);
                    }
                }
            }
            return -1;
        });
    }

    public static boolean isPrimitive(Class<?> c) {
        return c.isPrimitive() || prims.contains(c);
    }

    private static int comparePrimitiveToWrapper(Class<?> source, Class<?> destination) {
        try {
            return source.getField("TYPE").get(null).equals(destination) ? 0 : -1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static Class<?> forName(String name, ClassLoader classLoader) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        try {
            return ClassUtilities.internalClassForName(name, classLoader);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Security exception, classForName() call on: " + name, e);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Class<?> internalClassForName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> c = nameToClass.get(name);
        if (c != null) {
            return c;
        }
        c = ClassUtilities.loadClass(name, classLoader);
        if (ClassLoader.class.isAssignableFrom(c) || ProcessBuilder.class.isAssignableFrom(c) || Process.class.isAssignableFrom(c) || Constructor.class.isAssignableFrom(c) || Method.class.isAssignableFrom(c) || Field.class.isAssignableFrom(c)) {
            throw new SecurityException("For security reasons, cannot instantiate: " + c.getName());
        }
        nameToClass.put(name, c);
        return c;
    }

    private static Class<?> loadClass(String name, ClassLoader classLoader) throws ClassNotFoundException {
        String className = name;
        boolean arrayType = false;
        Class<Object> primitiveArray = null;
        while (className.startsWith("[")) {
            arrayType = true;
            if (className.endsWith(";")) {
                className = className.substring(0, className.length() - 1);
            }
            switch (className) {
                case "[B": {
                    primitiveArray = byte[].class;
                    break;
                }
                case "[S": {
                    primitiveArray = short[].class;
                    break;
                }
                case "[I": {
                    primitiveArray = int[].class;
                    break;
                }
                case "[J": {
                    primitiveArray = long[].class;
                    break;
                }
                case "[F": {
                    primitiveArray = float[].class;
                    break;
                }
                case "[D": {
                    primitiveArray = double[].class;
                    break;
                }
                case "[Z": {
                    primitiveArray = boolean[].class;
                    break;
                }
                case "[C": {
                    primitiveArray = char[].class;
                }
            }
            int startpos = className.startsWith("[L") ? 2 : 1;
            className = className.substring(startpos);
        }
        Class<?> currentClass = null;
        if (null == primitiveArray) {
            try {
                currentClass = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                currentClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
        }
        if (arrayType) {
            Class<Object> clazz = currentClass = null != primitiveArray ? primitiveArray : Array.newInstance(currentClass, 0).getClass();
            while (name.startsWith("[[")) {
                currentClass = Array.newInstance(currentClass, 0).getClass();
                name = name.substring(1);
            }
        }
        return currentClass;
    }

    public static boolean isClassFinal(Class<?> c) {
        return (c.getModifiers() & 0x10) != 0;
    }

    public static boolean areAllConstructorsPrivate(Class<?> c) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = c.getDeclaredConstructors()) {
            if ((constructor.getModifiers() & 2) != 0) continue;
            return false;
        }
        return true;
    }

    public static Class<?> toPrimitiveWrapperClass(Class<?> primitiveClass) {
        if (!primitiveClass.isPrimitive()) {
            return primitiveClass;
        }
        Class<?> c = primitiveToWrapper.get(primitiveClass);
        if (c == null) {
            throw new IllegalArgumentException("Passed in class: " + primitiveClass + " is not a primitive class");
        }
        return c;
    }

    public static boolean doesOneWrapTheOther(Class<?> x, Class<?> y) {
        return wrapperMap.get(x) == y;
    }

    public static ClassLoader getClassLoader() {
        return ClassUtilities.getClassLoader(ClassUtilities.class);
    }

    public static ClassLoader getClassLoader(Class<?> anchorClass) {
        if (anchorClass == null) {
            throw new IllegalArgumentException("Anchor class cannot be null");
        }
        ClassUtilities.checkSecurityAccess();
        ClassLoader cl = ClassUtilities.getOSGiClassLoader(anchorClass);
        if (cl != null) {
            return cl;
        }
        cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            return cl;
        }
        cl = anchorClass.getClassLoader();
        if (cl != null) {
            return cl;
        }
        return SYSTEM_LOADER;
    }

    private static void checkSecurityAccess() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getClassLoader"));
        }
    }

    private static ClassLoader getOSGiClassLoader(Class<?> classFromBundle) {
        return osgiClassLoaders.computeIfAbsent(classFromBundle, ClassUtilities::getOSGiClassLoader0);
    }

    private static ClassLoader getOSGiClassLoader0(Class<?> classFromBundle) {
        try {
            Class<?> frameworkUtilClass = Class.forName("org.osgi.framework.FrameworkUtil");
            Method getBundleMethod = frameworkUtilClass.getMethod("getBundle", Class.class);
            Object bundle = getBundleMethod.invoke(null, classFromBundle);
            if (bundle != null) {
                Method getClassLoaderMethod;
                Object classLoader;
                Class<?> bundleWiringClass = Class.forName("org.osgi.framework.wiring.BundleWiring");
                Method adaptMethod = bundle.getClass().getMethod("adapt", Class.class);
                Object bundleWiring = adaptMethod.invoke(bundle, bundleWiringClass);
                if (bundleWiring != null && (classLoader = (getClassLoaderMethod = bundleWiringClass.getMethod("getClassLoader", new Class[0])).invoke(bundleWiring, new Object[0])) instanceof ClassLoader) {
                    return (ClassLoader)classLoader;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static <T> T findClosest(Class<?> clazz, Map<Class<?>, T> candidateClasses, T defaultClass) {
        Convention.throwIfNull(clazz, "Source class cannot be null");
        Convention.throwIfNull(candidateClasses, "Candidate classes Map cannot be null");
        T exactMatch = candidateClasses.get(clazz);
        if (exactMatch != null) {
            return exactMatch;
        }
        T closest = defaultClass;
        int minDistance = Integer.MAX_VALUE;
        Class<?> closestClass = null;
        for (Map.Entry<Class<?>, T> entry : candidateClasses.entrySet()) {
            Class<?> candidateClass = entry.getKey();
            int distance = ClassUtilities.computeInheritanceDistance(clazz, candidateClass);
            if (distance == -1 || distance >= minDistance && (distance != minDistance || !ClassUtilities.shouldPreferNewCandidate(candidateClass, closestClass))) continue;
            minDistance = distance;
            closest = entry.getValue();
            closestClass = candidateClass;
        }
        return closest;
    }

    private static boolean shouldPreferNewCandidate(Class<?> newClass, Class<?> currentClass) {
        if (currentClass == null) {
            return true;
        }
        if (newClass.isInterface() != currentClass.isInterface()) {
            return !newClass.isInterface();
        }
        return newClass.isAssignableFrom(currentClass);
    }

    public static String loadResourceAsString(String resourceName) {
        byte[] resourceBytes = ClassUtilities.loadResourceAsBytes(resourceName);
        return new String(resourceBytes, StandardCharsets.UTF_8);
    }

    public static byte[] loadResourceAsBytes(String resourceName) {
        byte[] byArray;
        block9: {
            Objects.requireNonNull(resourceName, "resourceName cannot be null");
            InputStream inputStream = ClassUtilities.getClassLoader(ClassUtilities.class).getResourceAsStream(resourceName);
            try {
                if (inputStream == null) {
                    throw new IllegalArgumentException("Resource not found: " + resourceName);
                }
                byArray = ClassUtilities.readInputStreamFully(inputStream);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Error reading resource: " + resourceName, e);
                }
            }
            inputStream.close();
        }
        return byArray;
    }

    private static byte[] readInputStreamFully(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(65536);
        byte[] data = new byte[65536];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    private static Object getArgForType(com.cedarsoftware.util.convert.Converter converter, Class<?> argType) {
        if (ClassUtilities.isPrimitive(argType)) {
            return converter.convert(null, argType);
        }
        Supplier<Object> directClassMapping = DIRECT_CLASS_MAPPING.get(argType);
        if (directClassMapping != null) {
            return directClassMapping.get();
        }
        for (Map.Entry<Class<?>, Supplier<Object>> entry : ASSIGNABLE_CLASS_MAPPING.entrySet()) {
            if (!entry.getKey().isAssignableFrom(argType)) continue;
            return entry.getValue().get();
        }
        if (argType.isArray()) {
            return Array.newInstance(argType.getComponentType(), 0);
        }
        return null;
    }

    private static List<Object> matchArgumentsToParameters(com.cedarsoftware.util.convert.Converter converter, Collection<Object> values, Parameter[] parameterTypes, boolean useNull) {
        Object value;
        int i;
        ArrayList<Object> answer = new ArrayList<Object>();
        if (parameterTypes == null || parameterTypes.length == 0) {
            return answer;
        }
        ArrayList<Object> copyValues = new ArrayList<Object>(values);
        boolean[] parameterMatched = new boolean[parameterTypes.length];
        block2: for (i = 0; i < parameterTypes.length; ++i) {
            if (parameterMatched[i]) continue;
            Class<?> paramType = parameterTypes[i].getType();
            Iterator valueIter = copyValues.iterator();
            while (valueIter.hasNext()) {
                value = valueIter.next();
                if (value == null || value.getClass() != paramType) continue;
                answer.add(value);
                valueIter.remove();
                parameterMatched[i] = true;
                continue block2;
            }
        }
        for (i = 0; i < parameterTypes.length; ++i) {
            if (parameterMatched[i]) continue;
            Parameter parameter = parameterTypes[i];
            Class<?> paramType = parameter.getType();
            value = ClassUtilities.pickBestValue(paramType, copyValues);
            if (value == null) {
                if (useNull) {
                    value = paramType.isPrimitive() ? converter.convert(null, paramType) : null;
                } else {
                    value = ClassUtilities.getArgForType(converter, paramType);
                    if (value == null && paramType.isPrimitive()) {
                        value = converter.convert(null, paramType);
                    }
                }
            } else if (value != null && !paramType.isAssignableFrom(value.getClass())) {
                try {
                    value = converter.convert(value, paramType);
                }
                catch (Exception e) {
                    value = useNull ? null : ClassUtilities.getArgForType(converter, paramType);
                }
            }
            answer.add(value);
        }
        return answer;
    }

    private static Object pickBestValue(Class<?> param, List<Object> values) {
        int[] scores = new int[values.size()];
        int i = 0;
        for (Object value : values) {
            Class<?> valueClass;
            int inheritanceDistance;
            scores[i] = value == null ? (param.isPrimitive() ? Integer.MAX_VALUE : 1000) : ((inheritanceDistance = ClassUtilities.computeInheritanceDistance(valueClass = value.getClass(), param)) >= 0 ? inheritanceDistance : (ClassUtilities.doesOneWrapTheOther(param, valueClass) ? 1 : (Converter.isSimpleTypeConversionSupported(param, valueClass) ? 100 : Integer.MAX_VALUE)));
            ++i;
        }
        int bestIndex = -1;
        int bestScore = Integer.MAX_VALUE;
        for (i = 0; i < scores.length; ++i) {
            if (scores[i] >= bestScore) continue;
            bestScore = scores[i];
            bestIndex = i;
        }
        if (bestIndex >= 0 && bestScore < Integer.MAX_VALUE) {
            Object bestValue = values.get(bestIndex);
            values.remove(bestIndex);
            return bestValue;
        }
        return null;
    }

    public static int indexOfSmallestValue(int[] array) {
        if (array == null || array.length == 0) {
            return -1;
        }
        int minValue = Integer.MAX_VALUE;
        int minIndex = -1;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] >= minValue || array[i] <= -1) continue;
            minValue = array[i];
            minIndex = i;
        }
        return minIndex;
    }

    public static Class<?> getClassIfEnum(Class<?> c) {
        Class<?> current;
        if (c == null) {
            return null;
        }
        for (current = c; current != null && current != Object.class; current = current.getSuperclass()) {
            if (!current.isEnum() || Enum.class.equals(current)) continue;
            return current;
        }
        for (current = c.getEnclosingClass(); current != null; current = current.getEnclosingClass()) {
            if (!current.isEnum() || Enum.class.equals(current)) continue;
            return current;
        }
        return null;
    }

    public static Object newInstance(com.cedarsoftware.util.convert.Converter converter, Class<?> c, Collection<?> argumentValues) {
        if (c == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        if (c.isInterface()) {
            throw new IllegalArgumentException("Cannot instantiate interface: " + c.getName());
        }
        if (Modifier.isAbstract(c.getModifiers())) {
            throw new IllegalArgumentException("Cannot instantiate abstract class: " + c.getName());
        }
        Set<Class> securityChecks = CollectionUtilities.setOf(ProcessBuilder.class, Process.class, ClassLoader.class, Constructor.class, Method.class, Field.class, MethodHandle.class);
        for (Class check : securityChecks) {
            if (!check.isAssignableFrom(c)) continue;
            throw new IllegalArgumentException("For security reasons, json-io does not allow instantiation of: " + check.getName());
        }
        if ("java.lang.ProcessImpl".equals(c.getName())) {
            throw new IllegalArgumentException("For security reasons, json-io does not allow instantiation of: java.lang.ProcessImpl");
        }
        if (c.getEnclosingClass() != null && !Modifier.isStatic(c.getModifiers())) {
            try {
                Object enclosingInstance = ClassUtilities.newInstance(converter, c.getEnclosingClass(), Collections.emptyList());
                Constructor<?> constructor = ReflectionUtils.getConstructor(c, c.getEnclosingClass());
                if (constructor != null) {
                    return constructor.newInstance(enclosingInstance);
                }
            }
            catch (Exception enclosingInstance) {
                // empty catch block
            }
        }
        ArrayList normalizedArgs = argumentValues == null ? new ArrayList() : new ArrayList(argumentValues);
        Constructor<?>[] declaredConstructors = ReflectionUtils.getAllConstructors(c);
        TreeSet<ConstructorWithValues> constructorOrder = new TreeSet<ConstructorWithValues>();
        for (Constructor<?> constructor : declaredConstructors) {
            Parameter[] parameters = constructor.getParameters();
            List<Object> argsNonNull = ClassUtilities.matchArgumentsToParameters(converter, new ArrayList<Object>(normalizedArgs), parameters, false);
            List<Object> argsNull = ClassUtilities.matchArgumentsToParameters(converter, new ArrayList<Object>(normalizedArgs), parameters, true);
            constructorOrder.add(new ConstructorWithValues(constructor, argsNull.toArray(), argsNonNull.toArray()));
        }
        Exception lastException = null;
        for (ConstructorWithValues constructorWithValues : constructorOrder) {
            Constructor<?> constructor;
            constructor = constructorWithValues.constructor;
            try {
                return constructor.newInstance(constructorWithValues.argsNonNull);
            }
            catch (Exception e1) {
                try {
                    return constructor.newInstance(constructorWithValues.argsNull);
                }
                catch (Exception e2) {
                    lastException = e2;
                }
            }
        }
        Object instance = ClassUtilities.tryUnsafeInstantiation(c);
        if (instance != null) {
            return instance;
        }
        String msg = "Unable to instantiate: " + c.getName();
        if (lastException != null) {
            msg = msg + " - " + lastException.getMessage();
        }
        throw new IllegalArgumentException(msg);
    }

    static void trySetAccessible(AccessibleObject object) {
        ExceptionUtilities.safelyIgnoreException(() -> object.setAccessible(true));
    }

    private static Object tryUnsafeInstantiation(Class<?> c) {
        if (useUnsafe) {
            try {
                Object o = unsafe.allocateInstance(c);
                return o;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void setUseUnsafe(boolean state) {
        useUnsafe = state;
        if (state) {
            try {
                unsafe = new Unsafe();
            }
            catch (InvocationTargetException e) {
                useUnsafe = false;
            }
        }
    }

    public static Set<Class<?>> findLowestCommonSupertypesExcluding(Class<?> classA, Class<?> classB, Set<Class<?>> excluded) {
        if (classA == null || classB == null) {
            return Collections.emptySet();
        }
        if (classA.equals(classB)) {
            return excluded.contains(classA) ? Collections.emptySet() : Collections.singleton(classA);
        }
        Set<Class<Class<?>>> allA = ClassUtilities.getAllSupertypes(classA);
        Set<Class<?>> allB = ClassUtilities.getAllSupertypes(classB);
        allA.retainAll(allB);
        allA.removeAll(excluded);
        if (allA.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList candidates = new ArrayList(allA);
        candidates.sort((x, y) -> {
            int dx = ClassUtilities.getDepth(x);
            int dy = ClassUtilities.getDepth(y);
            return Integer.compare(dy, dx);
        });
        LinkedHashSet lowest = new LinkedHashSet();
        HashSet unionOfAncestors = new HashSet();
        for (Class clazz : candidates) {
            if (unionOfAncestors.contains(clazz)) continue;
            lowest.add(clazz);
            Set<Class<?>> ancestorsOfT = ClassUtilities.getAllSupertypes(clazz);
            unionOfAncestors.addAll(ancestorsOfT);
        }
        return lowest;
    }

    public static Set<Class<?>> findLowestCommonSupertypes(Class<?> classA, Class<?> classB) {
        return ClassUtilities.findLowestCommonSupertypesExcluding(classA, classB, CollectionUtilities.setOf(Object.class, Serializable.class, Externalizable.class, Cloneable.class));
    }

    public static Class<?> findLowestCommonSupertype(Class<?> classA, Class<?> classB) {
        Set<Class<?>> all = ClassUtilities.findLowestCommonSupertypes(classA, classB);
        return all.isEmpty() ? null : all.iterator().next();
    }

    public static Set<Class<?>> getAllSupertypes(Class<?> clazz) {
        Set cached = SUPER_TYPES_CACHE.computeIfAbsent(clazz, key -> {
            LinkedHashSet<Class> results = new LinkedHashSet<Class>();
            ArrayDeque queue = new ArrayDeque();
            queue.add((Class<?>)key);
            while (!queue.isEmpty()) {
                Class current = (Class)queue.poll();
                if (current == null || !results.add(current)) continue;
                Class sup = current.getSuperclass();
                if (sup != null) {
                    queue.add(sup);
                }
                queue.addAll(Arrays.asList(current.getInterfaces()));
            }
            return results;
        });
        return new LinkedHashSet(cached);
    }

    private static int getDepth(Class<?> clazz) {
        int depth = 0;
        while (clazz != null) {
            clazz = clazz.getSuperclass();
            ++depth;
        }
        return depth;
    }

    public static boolean haveCommonAncestor(Class<?> a, Class<?> b) {
        return !ClassUtilities.findLowestCommonSupertypes(a, b).isEmpty();
    }

    static {
        DIRECT_CLASS_MAPPING = new HashMap();
        ASSIGNABLE_CLASS_MAPPING = new LinkedHashMap();
        SUPER_TYPES_CACHE = new LRUCache(300);
        CLASS_DISTANCE_CACHE = new LRUCache(1000);
        DIRECT_CLASS_MAPPING.put(Date.class, Date::new);
        DIRECT_CLASS_MAPPING.put(StringBuilder.class, StringBuilder::new);
        DIRECT_CLASS_MAPPING.put(StringBuffer.class, StringBuffer::new);
        DIRECT_CLASS_MAPPING.put(Locale.class, Locale::getDefault);
        DIRECT_CLASS_MAPPING.put(TimeZone.class, TimeZone::getDefault);
        DIRECT_CLASS_MAPPING.put(Timestamp.class, () -> new Timestamp(System.currentTimeMillis()));
        DIRECT_CLASS_MAPPING.put(java.sql.Date.class, () -> new java.sql.Date(System.currentTimeMillis()));
        DIRECT_CLASS_MAPPING.put(LocalDate.class, LocalDate::now);
        DIRECT_CLASS_MAPPING.put(LocalDateTime.class, LocalDateTime::now);
        DIRECT_CLASS_MAPPING.put(OffsetDateTime.class, OffsetDateTime::now);
        DIRECT_CLASS_MAPPING.put(ZonedDateTime.class, ZonedDateTime::now);
        DIRECT_CLASS_MAPPING.put(ZoneId.class, ZoneId::systemDefault);
        DIRECT_CLASS_MAPPING.put(AtomicBoolean.class, AtomicBoolean::new);
        DIRECT_CLASS_MAPPING.put(AtomicInteger.class, AtomicInteger::new);
        DIRECT_CLASS_MAPPING.put(AtomicLong.class, AtomicLong::new);
        DIRECT_CLASS_MAPPING.put(URL.class, () -> ExceptionUtilities.safelyIgnoreException(() -> new URL("http://localhost"), null));
        DIRECT_CLASS_MAPPING.put(URI.class, () -> ExceptionUtilities.safelyIgnoreException(() -> new URI("http://localhost"), null));
        DIRECT_CLASS_MAPPING.put(Object.class, Object::new);
        DIRECT_CLASS_MAPPING.put(String.class, () -> "");
        DIRECT_CLASS_MAPPING.put(BigInteger.class, () -> BigInteger.ZERO);
        DIRECT_CLASS_MAPPING.put(BigDecimal.class, () -> BigDecimal.ZERO);
        DIRECT_CLASS_MAPPING.put(Class.class, () -> String.class);
        DIRECT_CLASS_MAPPING.put(Calendar.class, Calendar::getInstance);
        DIRECT_CLASS_MAPPING.put(Instant.class, Instant::now);
        ASSIGNABLE_CLASS_MAPPING.put(EnumSet.class, () -> null);
        ASSIGNABLE_CLASS_MAPPING.put(List.class, ArrayList::new);
        ASSIGNABLE_CLASS_MAPPING.put(NavigableSet.class, TreeSet::new);
        ASSIGNABLE_CLASS_MAPPING.put(SortedSet.class, TreeSet::new);
        ASSIGNABLE_CLASS_MAPPING.put(Set.class, LinkedHashSet::new);
        ASSIGNABLE_CLASS_MAPPING.put(NavigableMap.class, TreeMap::new);
        ASSIGNABLE_CLASS_MAPPING.put(SortedMap.class, TreeMap::new);
        ASSIGNABLE_CLASS_MAPPING.put(Map.class, LinkedHashMap::new);
        ASSIGNABLE_CLASS_MAPPING.put(Collection.class, ArrayList::new);
        ASSIGNABLE_CLASS_MAPPING.put(Calendar.class, Calendar::getInstance);
        ASSIGNABLE_CLASS_MAPPING.put(LinkedHashSet.class, LinkedHashSet::new);
        prims.add(Byte.class);
        prims.add(Short.class);
        prims.add(Integer.class);
        prims.add(Long.class);
        prims.add(Float.class);
        prims.add(Double.class);
        prims.add(Character.class);
        prims.add(Boolean.class);
        nameToClass.put("boolean", Boolean.TYPE);
        nameToClass.put("char", Character.TYPE);
        nameToClass.put("byte", Byte.TYPE);
        nameToClass.put("short", Short.TYPE);
        nameToClass.put("int", Integer.TYPE);
        nameToClass.put("long", Long.TYPE);
        nameToClass.put("float", Float.TYPE);
        nameToClass.put("double", Double.TYPE);
        nameToClass.put("string", String.class);
        nameToClass.put("date", Date.class);
        nameToClass.put("class", Class.class);
        primitiveToWrapper.put(Integer.TYPE, Integer.class);
        primitiveToWrapper.put(Long.TYPE, Long.class);
        primitiveToWrapper.put(Double.TYPE, Double.class);
        primitiveToWrapper.put(Float.TYPE, Float.class);
        primitiveToWrapper.put(Boolean.TYPE, Boolean.class);
        primitiveToWrapper.put(Character.TYPE, Character.class);
        primitiveToWrapper.put(Byte.TYPE, Byte.class);
        primitiveToWrapper.put(Short.TYPE, Short.class);
        primitiveToWrapper.put(Void.TYPE, Void.class);
        wrapperMap.put(Integer.TYPE, Integer.class);
        wrapperMap.put(Integer.class, Integer.TYPE);
        wrapperMap.put(Character.TYPE, Character.class);
        wrapperMap.put(Character.class, Character.TYPE);
        wrapperMap.put(Byte.TYPE, Byte.class);
        wrapperMap.put(Byte.class, Byte.TYPE);
        wrapperMap.put(Short.TYPE, Short.class);
        wrapperMap.put(Short.class, Short.TYPE);
        wrapperMap.put(Long.TYPE, Long.class);
        wrapperMap.put(Long.class, Long.TYPE);
        wrapperMap.put(Float.TYPE, Float.class);
        wrapperMap.put(Float.class, Float.TYPE);
        wrapperMap.put(Double.TYPE, Double.class);
        wrapperMap.put(Double.class, Double.TYPE);
        wrapperMap.put(Boolean.TYPE, Boolean.class);
        wrapperMap.put(Boolean.class, Boolean.TYPE);
    }

    private static class ConstructorWithValues
    implements Comparable<ConstructorWithValues> {
        final Constructor<?> constructor;
        final Object[] argsNull;
        final Object[] argsNonNull;

        ConstructorWithValues(Constructor<?> constructor, Object[] argsNull, Object[] argsNonNull) {
            this.constructor = constructor;
            this.argsNull = argsNull;
            this.argsNonNull = argsNonNull;
        }

        @Override
        public int compareTo(ConstructorWithValues other) {
            long score2;
            int mods = this.constructor.getModifiers();
            int otherMods = other.constructor.getModifiers();
            if (!Modifier.isPublic(mods) && Modifier.isPublic(otherMods)) {
                return 1;
            }
            if (Modifier.isPublic(mods) && !Modifier.isPublic(otherMods)) {
                return -1;
            }
            if (!Modifier.isProtected(mods) && Modifier.isProtected(otherMods)) {
                return 1;
            }
            if (Modifier.isProtected(mods) && !Modifier.isProtected(otherMods)) {
                return -1;
            }
            long score1 = this.scoreArgumentValues(this.argsNull);
            if (score1 < (score2 = this.scoreArgumentValues(other.argsNull))) {
                return 1;
            }
            if (score1 > score2) {
                return -1;
            }
            score1 = this.scoreArgumentValues(this.argsNonNull);
            if (score1 < (score2 = this.scoreArgumentValues(other.argsNonNull))) {
                return 1;
            }
            if (score1 > score2) {
                return -1;
            }
            String params1 = this.buildParameterTypeString(this.constructor);
            String params2 = this.buildParameterTypeString(other.constructor);
            return params1.compareTo(params2);
        }

        private long scoreArgumentValues(Object[] args) {
            if (args.length == 0) {
                return 0L;
            }
            int nonNull = 0;
            for (Object arg : args) {
                if (arg == null) continue;
                ++nonNull;
            }
            return (long)nonNull * 100L + (long)args.length * 50L;
        }

        private String buildParameterTypeString(Constructor<?> constructor) {
            Class<?>[] paramTypes = constructor.getParameterTypes();
            StringBuilder s = new StringBuilder();
            for (Class<?> paramType : paramTypes) {
                s.append(paramType.getName()).append(".");
            }
            return s.toString();
        }
    }
}

