/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.AbstractConcurrentNullSafeMap;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class ConcurrentNavigableMapNullSafe<K, V>
extends AbstractConcurrentNullSafeMap<K, V>
implements ConcurrentNavigableMap<K, V> {
    private final Comparator<? super K> originalComparator;
    private static final Object NULL_KEY_SENTINEL = new Object();

    public ConcurrentNavigableMapNullSafe() {
        this((Comparator<K>)null);
    }

    public ConcurrentNavigableMapNullSafe(Comparator<? super K> comparator) {
        this(new ConcurrentSkipListMap<Object, Object>(ConcurrentNavigableMapNullSafe.wrapComparator(comparator)), comparator);
    }

    private ConcurrentNavigableMapNullSafe(ConcurrentNavigableMap<Object, Object> internalMap, Comparator<? super K> originalComparator) {
        super(internalMap);
        this.originalComparator = originalComparator;
    }

    private static <K> Comparator<Object> wrapComparator(Comparator<? super K> comparator) {
        return (o1, o2) -> {
            ClassLoader cl2;
            String loader2;
            String className2;
            Class<?> class2;
            boolean o2IsNullSentinel;
            boolean o1IsNullSentinel = o1 == NULL_KEY_SENTINEL;
            boolean bl = o2IsNullSentinel = o2 == NULL_KEY_SENTINEL;
            if (o1IsNullSentinel && o2IsNullSentinel) {
                return 0;
            }
            if (o1IsNullSentinel) {
                return 1;
            }
            if (o2IsNullSentinel) {
                return -1;
            }
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (comparator != null) {
                return comparator.compare((Object)o1, (Object)o2);
            }
            Class<?> class1 = o1.getClass();
            if (class1 == (class2 = o2.getClass()) && o1 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            String className1 = class1.getName();
            int classComparison = className1.compareTo(className2 = class2.getName());
            if (classComparison != 0) {
                return classComparison;
            }
            ClassLoader cl1 = class1.getClassLoader();
            String loader1 = cl1 == null ? "" : cl1.getClass().getName();
            int loaderCompare = loader1.compareTo(loader2 = (cl2 = class2.getClassLoader()) == null ? "" : cl2.getClass().getName());
            if (loaderCompare != 0) {
                return loaderCompare;
            }
            return Integer.compare(System.identityHashCode(cl1), System.identityHashCode(cl2));
        };
    }

    @Override
    protected Object maskNullKey(Object key) {
        if (key == null) {
            return NULL_KEY_SENTINEL;
        }
        return key;
    }

    @Override
    protected K unmaskNullKey(Object maskedKey) {
        if (maskedKey == NULL_KEY_SENTINEL) {
            return null;
        }
        return (K)maskedKey;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.originalComparator;
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        NavigableMap subInternal = ((ConcurrentNavigableMap)this.internalMap).subMap(this.maskNullKey(fromKey), fromInclusive, this.maskNullKey(toKey), toInclusive);
        return new ConcurrentNavigableMapNullSafe<K, V>((ConcurrentNavigableMap<Object, Object>)subInternal, this.originalComparator);
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        NavigableMap headInternal = ((ConcurrentNavigableMap)this.internalMap).headMap(this.maskNullKey(toKey), inclusive);
        return new ConcurrentNavigableMapNullSafe<K, V>((ConcurrentNavigableMap<Object, Object>)headInternal, this.originalComparator);
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        NavigableMap tailInternal = ((ConcurrentNavigableMap)this.internalMap).tailMap(this.maskNullKey(fromKey), inclusive);
        return new ConcurrentNavigableMapNullSafe<K, V>((ConcurrentNavigableMap<Object, Object>)tailInternal, this.originalComparator);
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap((Object)fromKey, true, (Object)toKey, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K toKey) {
        return this.headMap((Object)toKey, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K fromKey) {
        return this.tailMap((Object)fromKey, true);
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        Map.Entry<Object, Object> entry = ((ConcurrentSkipListMap)this.internalMap).lowerEntry(this.maskNullKey(key));
        return this.wrapEntry(entry);
    }

    @Override
    public K lowerKey(K key) {
        return this.unmaskNullKey(((ConcurrentSkipListMap)this.internalMap).lowerKey(this.maskNullKey(key)));
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        Map.Entry<Object, Object> entry = ((ConcurrentSkipListMap)this.internalMap).floorEntry(this.maskNullKey(key));
        return this.wrapEntry(entry);
    }

    @Override
    public K floorKey(K key) {
        return this.unmaskNullKey(((ConcurrentSkipListMap)this.internalMap).floorKey(this.maskNullKey(key)));
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        Map.Entry<Object, Object> entry = ((ConcurrentSkipListMap)this.internalMap).ceilingEntry(this.maskNullKey(key));
        return this.wrapEntry(entry);
    }

    @Override
    public K ceilingKey(K key) {
        return this.unmaskNullKey(((ConcurrentSkipListMap)this.internalMap).ceilingKey(this.maskNullKey(key)));
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        Map.Entry<Object, Object> entry = ((ConcurrentSkipListMap)this.internalMap).higherEntry(this.maskNullKey(key));
        return this.wrapEntry(entry);
    }

    @Override
    public K higherKey(K key) {
        return this.unmaskNullKey(((ConcurrentSkipListMap)this.internalMap).higherKey(this.maskNullKey(key)));
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        Map.Entry<Object, Object> entry = ((ConcurrentSkipListMap)this.internalMap).firstEntry();
        return this.wrapEntry(entry);
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        Map.Entry<Object, Object> entry = ((ConcurrentSkipListMap)this.internalMap).lastEntry();
        return this.wrapEntry(entry);
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        Map.Entry entry = ((ConcurrentSkipListMap)this.internalMap).pollFirstEntry();
        if (entry == null) {
            return null;
        }
        K key = this.unmaskNullKey(entry.getKey());
        Object value = this.unmaskNullValue(entry.getValue());
        return new AbstractMap.SimpleImmutableEntry(key, value);
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        Map.Entry entry = ((ConcurrentSkipListMap)this.internalMap).pollLastEntry();
        if (entry == null) {
            return null;
        }
        K key = this.unmaskNullKey(entry.getKey());
        Object value = this.unmaskNullValue(entry.getValue());
        return new AbstractMap.SimpleImmutableEntry(key, value);
    }

    @Override
    public K firstKey() {
        return this.unmaskNullKey(((ConcurrentSkipListMap)this.internalMap).firstKey());
    }

    @Override
    public K lastKey() {
        return this.unmaskNullKey(((ConcurrentSkipListMap)this.internalMap).lastKey());
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return this.keySet();
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public ConcurrentNavigableMap<K, V> descendingMap() {
        NavigableMap descInternal = ((ConcurrentNavigableMap)this.internalMap).descendingMap();
        return new ConcurrentNavigableMapNullSafe<K, V>((ConcurrentNavigableMap<Object, Object>)descInternal, this.originalComparator);
    }

    @Override
    public NavigableSet<K> keySet() {
        Set<Object> internalKeys = this.internalMap.keySet();
        return new KeyNavigableSet(this, internalKeys);
    }

    private Map.Entry<K, V> wrapEntry(Map.Entry<Object, Object> internalEntry) {
        if (internalEntry == null) {
            return null;
        }
        final Object keyObj = internalEntry.getKey();
        return new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return ConcurrentNavigableMapNullSafe.this.unmaskNullKey(keyObj);
            }

            @Override
            public V getValue() {
                return ConcurrentNavigableMapNullSafe.this.unmaskNullValue(ConcurrentNavigableMapNullSafe.this.internalMap.get(keyObj));
            }

            @Override
            public V setValue(V value) {
                Object old = ConcurrentNavigableMapNullSafe.this.internalMap.put(keyObj, ConcurrentNavigableMapNullSafe.this.maskNullValue(value));
                return ConcurrentNavigableMapNullSafe.this.unmaskNullValue(old);
            }

            @Override
            public boolean equals(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return Objects.equals(this.getKey(), e.getKey()) && Objects.equals(this.getValue(), e.getValue());
            }

            @Override
            public int hashCode() {
                return Objects.hashCode(this.getKey()) ^ Objects.hashCode(this.getValue());
            }

            public String toString() {
                return this.getKey() + "=" + this.getValue();
            }
        };
    }

    private static class KeyNavigableSet<K, V>
    extends AbstractSet<K>
    implements NavigableSet<K> {
        private final ConcurrentNavigableMapNullSafe<K, V> owner;
        private final Set<Object> internalKeys;

        KeyNavigableSet(ConcurrentNavigableMapNullSafe<K, V> owner, Set<Object> internalKeys) {
            this.owner = owner;
            this.internalKeys = internalKeys;
        }

        @Override
        public Iterator<K> iterator() {
            final Iterator<Object> it = this.internalKeys.iterator();
            return new Iterator<K>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public K next() {
                    return owner.unmaskNullKey(it.next());
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
        }

        @Override
        public int size() {
            return this.internalKeys.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.owner.internalMap.containsKey(this.owner.maskNullKey(o));
        }

        @Override
        public boolean remove(Object o) {
            return this.owner.internalMap.remove(this.owner.maskNullKey(o)) != null;
        }

        @Override
        public void clear() {
            this.owner.internalMap.clear();
        }

        @Override
        public K lower(K k) {
            return this.owner.unmaskNullKey(((ConcurrentSkipListMap)this.owner.internalMap).lowerKey(this.owner.maskNullKey(k)));
        }

        @Override
        public K floor(K k) {
            return this.owner.unmaskNullKey(((ConcurrentSkipListMap)this.owner.internalMap).floorKey(this.owner.maskNullKey(k)));
        }

        @Override
        public K ceiling(K k) {
            return this.owner.unmaskNullKey(((ConcurrentSkipListMap)this.owner.internalMap).ceilingKey(this.owner.maskNullKey(k)));
        }

        @Override
        public K higher(K k) {
            return this.owner.unmaskNullKey(((ConcurrentSkipListMap)this.owner.internalMap).higherKey(this.owner.maskNullKey(k)));
        }

        @Override
        public K pollFirst() {
            Map.Entry entry = ((ConcurrentSkipListMap)this.owner.internalMap).pollFirstEntry();
            return entry == null ? null : (K)this.owner.unmaskNullKey(entry.getKey());
        }

        @Override
        public K pollLast() {
            Map.Entry entry = ((ConcurrentSkipListMap)this.owner.internalMap).pollLastEntry();
            return entry == null ? null : (K)this.owner.unmaskNullKey(entry.getKey());
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.owner.comparator();
        }

        @Override
        public K first() {
            return this.owner.unmaskNullKey(((ConcurrentSkipListMap)this.owner.internalMap).firstKey());
        }

        @Override
        public K last() {
            return this.owner.unmaskNullKey(((ConcurrentSkipListMap)this.owner.internalMap).lastKey());
        }

        @Override
        public NavigableSet<K> descendingSet() {
            return this.owner.descendingKeySet();
        }

        @Override
        public Iterator<K> descendingIterator() {
            final Iterator it = ((ConcurrentSkipListMap)this.owner.internalMap).descendingKeySet().iterator();
            return new Iterator<K>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public K next() {
                    return owner.unmaskNullKey(it.next());
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
        }

        @Override
        public NavigableSet<K> subSet(K fromElement, boolean fromInclusive, K toElement, boolean toInclusive) {
            NavigableMap subMap = this.owner.subMap((Object)fromElement, fromInclusive, (Object)toElement, toInclusive);
            return subMap.navigableKeySet();
        }

        @Override
        public NavigableSet<K> headSet(K toElement, boolean inclusive) {
            NavigableMap headMap = this.owner.headMap((Object)toElement, inclusive);
            return headMap.navigableKeySet();
        }

        @Override
        public NavigableSet<K> tailSet(K fromElement, boolean inclusive) {
            NavigableMap tailMap = this.owner.tailMap((Object)fromElement, inclusive);
            return tailMap.navigableKeySet();
        }

        @Override
        public SortedSet<K> subSet(K fromElement, K toElement) {
            return this.subSet(fromElement, true, toElement, false);
        }

        @Override
        public SortedSet<K> headSet(K toElement) {
            return this.headSet(toElement, false);
        }

        @Override
        public SortedSet<K> tailSet(K fromElement) {
            return this.tailSet(fromElement, true);
        }
    }
}

