/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;

public class SafeSimpleDateFormat
extends DateFormat {
    private static final long serialVersionUID = 1L;
    private static final int STATIC_PER_THREAD_LRU_CAPACITY = 16;
    private static final ThreadLocal<Map<String, SimpleDateFormat>> STATIC_TL = ThreadLocal.withInitial(() -> new LinkedHashMap<String, SimpleDateFormat>(24, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, SimpleDateFormat> eldest) {
            return this.size() > 16;
        }
    });
    private static final int PER_THREAD_LRU_CAPACITY = 4;
    private static final ThreadLocal<Map<State, SimpleDateFormat>> TL = ThreadLocal.withInitial(() -> new LinkedHashMap<State, SimpleDateFormat>(8, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<State, SimpleDateFormat> eldest) {
            return this.size() > 4;
        }
    });
    private final AtomicReference<State> stateRef;

    public static SimpleDateFormat getDateFormat(String pattern) {
        Objects.requireNonNull(pattern, "pattern");
        Map<String, SimpleDateFormat> m = STATIC_TL.get();
        SimpleDateFormat sdf = m.get(pattern);
        if (sdf == null) {
            Locale loc = Locale.getDefault();
            TimeZone tz = TimeZone.getDefault();
            SimpleDateFormat fresh = new SimpleDateFormat(pattern, DateFormatSymbols.getInstance(loc));
            fresh.setTimeZone(tz);
            fresh.setLenient(true);
            NumberFormat nf = SafeSimpleDateFormat.defaultNumberFormat();
            fresh.setNumberFormat((NumberFormat)nf.clone());
            Calendar cal = Calendar.getInstance(tz, loc);
            cal.clear();
            fresh.setCalendar(cal);
            m.put(pattern, fresh);
            sdf = fresh;
        }
        return sdf;
    }

    public static void clearStaticThreadLocalCache() {
        STATIC_TL.remove();
    }

    private static NumberFormat defaultNumberFormat() {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setGroupingUsed(false);
        return nf;
    }

    public SafeSimpleDateFormat(String format) {
        Locale locale = Locale.getDefault();
        TimeZone tz = TimeZone.getDefault();
        this.calendar = Calendar.getInstance(tz, locale);
        this.numberFormat = SafeSimpleDateFormat.defaultNumberFormat();
        this.stateRef = new AtomicReference<State>(new State(format, locale, tz, true, this.numberFormat, DateFormatSymbols.getInstance(locale), null));
    }

    private static Map<State, SimpleDateFormat> currentThreadCache() {
        return TL.get();
    }

    private SimpleDateFormat getSdf() {
        State st = this.stateRef.get();
        return SafeSimpleDateFormat.currentThreadCache().computeIfAbsent(st, State::build);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        return this.getSdf().format(date, toAppendTo, fieldPosition);
    }

    @Override
    public Date parse(String source, ParsePosition pos) {
        return this.getSdf().parse(source, pos);
    }

    @Override
    public void setTimeZone(TimeZone tz) {
        this.update(s -> new State(s.pattern, s.locale, Objects.requireNonNull(tz, "tz"), s.lenient, s.nf, s.symbols, s.twoDigitYearStartEpochMs));
        if (this.calendar != null) {
            this.calendar.setTimeZone(tz);
        }
    }

    @Override
    public void setLenient(boolean lenient) {
        this.update(s -> new State(s.pattern, s.locale, s.tz, lenient, s.nf, s.symbols, s.twoDigitYearStartEpochMs));
        if (this.calendar != null) {
            this.calendar.setLenient(lenient);
        }
    }

    @Override
    public void setCalendar(Calendar cal) {
        Objects.requireNonNull(cal, "cal");
        TimeZone tz = cal.getTimeZone();
        boolean len = cal.isLenient();
        this.update(s -> new State(s.pattern, s.locale, tz, len, s.nf, s.symbols, s.twoDigitYearStartEpochMs));
        this.calendar = cal;
    }

    @Override
    public void setNumberFormat(NumberFormat format) {
        Objects.requireNonNull(format, "format");
        this.update(s -> new State(s.pattern, s.locale, s.tz, s.lenient, format, s.symbols, s.twoDigitYearStartEpochMs));
        this.numberFormat = format;
    }

    public void setDateFormatSymbols(DateFormatSymbols symbols) {
        Objects.requireNonNull(symbols, "symbols");
        this.update(s -> new State(s.pattern, s.locale, s.tz, s.lenient, s.nf, symbols, s.twoDigitYearStartEpochMs));
    }

    public void set2DigitYearStart(Date date) {
        Objects.requireNonNull(date, "date");
        long epochMs = date.getTime();
        this.update(s -> new State(s.pattern, s.locale, s.tz, s.lenient, s.nf, s.symbols, epochMs));
    }

    public String toString() {
        return this.stateRef.get().pattern;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SafeSimpleDateFormat)) {
            return false;
        }
        SafeSimpleDateFormat that = (SafeSimpleDateFormat)other;
        return this.stateRef.get().equals(that.stateRef.get());
    }

    @Override
    public int hashCode() {
        return this.stateRef.get().hashCode();
    }

    private void update(UnaryOperator<State> fn) {
        State newSt;
        State oldSt;
        do {
            if (!(oldSt = this.stateRef.get()).equals(newSt = Objects.requireNonNull((State)fn.apply(oldSt), "new state"))) continue;
            return;
        } while (!this.stateRef.compareAndSet(oldSt, newSt));
        SafeSimpleDateFormat.currentThreadCache().remove(oldSt);
    }

    public static void clearThreadLocalCache() {
        TL.remove();
    }

    public void clearThreadLocal() {
        SafeSimpleDateFormat.currentThreadCache().remove(this.stateRef.get());
    }

    private static final class State {
        final String pattern;
        final Locale locale;
        final TimeZone tz;
        final boolean lenient;
        final DateFormatSymbols symbols;
        final NumberFormat nf;
        final NFSig nfSig;
        final Long twoDigitYearStartEpochMs;

        State(String pattern, Locale locale, TimeZone tz, boolean lenient, NumberFormat nf, DateFormatSymbols symbols, Long twoDigitYearStartEpochMs) {
            this.pattern = Objects.requireNonNull(pattern, "pattern");
            this.locale = Objects.requireNonNull(locale, "locale");
            this.tz = (TimeZone)Objects.requireNonNull(tz, "tz").clone();
            this.lenient = lenient;
            this.nf = (NumberFormat)Objects.requireNonNull(nf, "numberFormat").clone();
            this.symbols = (DateFormatSymbols)Objects.requireNonNull(symbols, "symbols").clone();
            this.twoDigitYearStartEpochMs = twoDigitYearStartEpochMs;
            this.nfSig = NFSig.of(this.nf);
        }

        SimpleDateFormat build() {
            SimpleDateFormat sdf = new SimpleDateFormat(this.pattern, this.symbols);
            sdf.setTimeZone(this.tz);
            sdf.setNumberFormat((NumberFormat)this.nf.clone());
            if (this.twoDigitYearStartEpochMs != null) {
                sdf.set2DigitYearStart(new Date(this.twoDigitYearStartEpochMs));
            }
            Calendar cal = Calendar.getInstance(this.tz, this.locale);
            cal.clear();
            cal.setLenient(this.lenient);
            sdf.setCalendar(cal);
            sdf.setLenient(this.lenient);
            return sdf;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof State)) {
                return false;
            }
            State s = (State)o;
            return this.lenient == s.lenient && this.pattern.equals(s.pattern) && this.locale.equals(s.locale) && State.tzIdEquals(this.tz, s.tz) && Objects.equals(this.twoDigitYearStartEpochMs, s.twoDigitYearStartEpochMs) && this.symbols.equals(s.symbols) && this.nfSig.equals(s.nfSig);
        }

        public int hashCode() {
            return Objects.hash(this.pattern, this.locale, State.tzIdHash(this.tz), this.lenient, this.symbols, this.nfSig, this.twoDigitYearStartEpochMs);
        }

        private static boolean tzIdEquals(TimeZone a, TimeZone b) {
            return Objects.equals(a.getID(), b.getID());
        }

        private static int tzIdHash(TimeZone tz) {
            return Objects.hashCode(tz.getID());
        }
    }

    private static final class NFSig {
        final Class<?> type;
        final boolean grouping;
        final boolean parseIntegerOnly;
        final int minInt;
        final int maxInt;
        final int minFrac;
        final int maxFrac;
        final RoundingMode roundingMode;

        NFSig(Class<?> type, boolean grouping, boolean parseIntegerOnly, int minInt, int maxInt, int minFrac, int maxFrac, RoundingMode rm) {
            this.type = type;
            this.grouping = grouping;
            this.parseIntegerOnly = parseIntegerOnly;
            this.minInt = minInt;
            this.maxInt = maxInt;
            this.minFrac = minFrac;
            this.maxFrac = maxFrac;
            this.roundingMode = rm;
        }

        static NFSig of(NumberFormat nf) {
            RoundingMode rm = null;
            try {
                rm = nf.getRoundingMode();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new NFSig(nf.getClass(), nf.isGroupingUsed(), nf.isParseIntegerOnly(), nf.getMinimumIntegerDigits(), nf.getMaximumIntegerDigits(), nf.getMinimumFractionDigits(), nf.getMaximumFractionDigits(), rm);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NFSig)) {
                return false;
            }
            NFSig n = (NFSig)o;
            return this.grouping == n.grouping && this.parseIntegerOnly == n.parseIntegerOnly && this.minInt == n.minInt && this.maxInt == n.maxInt && this.minFrac == n.minFrac && this.maxFrac == n.maxFrac && Objects.equals(this.type, n.type) && Objects.equals((Object)this.roundingMode, (Object)n.roundingMode);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.grouping, this.parseIntegerOnly, this.minInt, this.maxInt, this.minFrac, this.maxFrac, this.roundingMode});
        }
    }
}

