/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.FastPushbackBufferedReader;
import com.cedarsoftware.util.io.FastPushbackReader;
import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonParser;
import com.cedarsoftware.util.io.MapResolver;
import com.cedarsoftware.util.io.MetaUtils;
import com.cedarsoftware.util.io.ObjectResolver;
import com.cedarsoftware.util.io.Readers;
import com.cedarsoftware.util.io.Resolver;
import com.cedarsoftware.util.io.factory.LocalDateFactory;
import com.cedarsoftware.util.io.factory.LocalDateTimeFactory;
import com.cedarsoftware.util.io.factory.LocalTimeFactory;
import com.cedarsoftware.util.io.factory.TimeZoneFactory;
import com.cedarsoftware.util.io.factory.ZonedDateTimeFactory;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class JsonReader
implements Closeable {
    public static final String CUSTOM_READER_MAP = "CUSTOM_READERS";
    public static final String NOT_CUSTOM_READER_MAP = "NOT_CUSTOM_READERS";
    public static final String USE_MAPS = "USE_MAPS";
    public static final String UNKNOWN_OBJECT = "UNKNOWN_OBJECT";
    public static final String FAIL_ON_UNKNOWN_TYPE = "FAIL_ON_UNKNOWN_TYPE";
    public static final String JSON_READER = "JSON_READER";
    public static final String OBJECT_RESOLVER = "OBJECT_RESOLVER";
    public static final String TYPE_NAME_MAP = "TYPE_NAME_MAP";
    public static final String MISSING_FIELD_HANDLER = "MISSING_FIELD_HANDLER";
    public static final String CLASSLOADER = "CLASSLOADER";
    static final String TYPE_NAME_MAP_REVERSE = "TYPE_NAME_MAP_REVERSE";
    public static final String FACTORIES = "FACTORIES";
    static final int DEFAULT_MAX_PARSE_DEPTH = 1000;
    protected static Map<Class<?>, JsonClassReader> BASE_READERS;
    protected final Map<Class<?>, JsonClassReader> readers = new HashMap(BASE_READERS);
    protected final Map<String, ClassFactory> classFactories = new HashMap<String, ClassFactory>(BASE_CLASS_FACTORIES);
    protected MissingFieldHandler missingFieldHandler;
    protected final Set<Class<?>> notCustom = new HashSet();
    protected static final Map<String, ClassFactory> BASE_CLASS_FACTORIES;
    private final FastPushbackReader input;
    private final Map<String, Object> args = new HashMap<String, Object>();
    private final int maxParseDepth;
    private static volatile boolean allowNanAndInfinity;

    private static void addPossibleReader(Map map, String fqClassName, Supplier<JsonClassReader> reader) {
        try {
            map.put(Class.forName(fqClassName), reader.get());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static void assignInstantiator(String className, ClassFactory factory) {
        BASE_CLASS_FACTORIES.put(className, factory);
    }

    public static void assignInstantiator(Class c, ClassFactory factory) {
        BASE_CLASS_FACTORIES.put(c.getName(), factory);
    }

    @Deprecated
    public void addReader(Class c, JsonClassReader reader) {
        this.readers.put(c, reader);
    }

    public static void addReaderPermanent(Class c, JsonClassReader reader) {
        BASE_READERS.put(c, reader);
    }

    public void addNotCustomReader(Class c) {
        this.notCustom.add(c);
    }

    public static <T> T jsonToJava(String json) {
        return JsonReader.jsonToJava(json, null);
    }

    public static Object jsonToJava(String json, Map<String, Object> optionalArgs, int maxDepth) {
        if (json == null || "".equals(json.trim())) {
            return null;
        }
        if (optionalArgs == null) {
            optionalArgs = new HashMap<String, Object>();
            optionalArgs.put(USE_MAPS, false);
        }
        if (!optionalArgs.containsKey(USE_MAPS)) {
            optionalArgs.put(USE_MAPS, false);
        }
        JsonReader jr = new JsonReader(json, optionalArgs, maxDepth);
        Object obj = jr.readObject();
        jr.close();
        return obj;
    }

    public static <T> T jsonToJava(String json, Map<String, Object> optionalArgs) {
        return (T)JsonReader.jsonToJava(json, optionalArgs, 1000);
    }

    public static <T> T jsonToJava(InputStream inputStream, Map<String, Object> optionalArgs, int maxDepth) {
        if (optionalArgs == null) {
            optionalArgs = new HashMap<String, Object>();
            optionalArgs.put(USE_MAPS, false);
        }
        if (!optionalArgs.containsKey(USE_MAPS)) {
            optionalArgs.put(USE_MAPS, false);
        }
        JsonReader jr = new JsonReader(inputStream, optionalArgs, maxDepth);
        Object obj = jr.readObject();
        jr.close();
        return (T)obj;
    }

    public static <T> T jsonToJava(InputStream inputStream, Map<String, Object> optionalArgs) {
        return JsonReader.jsonToJava(inputStream, optionalArgs, 1000);
    }

    public static Map jsonToMaps(String json, int maxDepth) {
        return JsonReader.jsonToMaps(json, null, maxDepth);
    }

    public static Map jsonToMaps(String json) {
        return JsonReader.jsonToMaps(json, 1000);
    }

    public static Map jsonToMaps(String json, Map<String, Object> optionalArgs, int maxDepth) {
        if (optionalArgs == null) {
            optionalArgs = new HashMap<String, Object>();
        }
        optionalArgs.put(USE_MAPS, true);
        ByteArrayInputStream ba = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
        JsonReader jr = new JsonReader((InputStream)ba, optionalArgs, maxDepth);
        Object ret = jr.readObject();
        jr.close();
        return JsonReader.adjustOutputMap(ret);
    }

    public static Map jsonToMaps(String json, Map<String, Object> optionalArgs) {
        return JsonReader.jsonToMaps(json, optionalArgs, 1000);
    }

    public static Map jsonToMaps(InputStream inputStream, Map<String, Object> optionalArgs, int maxDepth) {
        if (optionalArgs == null) {
            optionalArgs = new HashMap<String, Object>();
        }
        optionalArgs.put(USE_MAPS, true);
        JsonReader jr = new JsonReader(inputStream, optionalArgs, maxDepth);
        Object ret = jr.readObject();
        jr.close();
        return JsonReader.adjustOutputMap(ret);
    }

    public static Map jsonToMaps(InputStream inputStream, Map<String, Object> optionalArgs) {
        return JsonReader.jsonToMaps(inputStream, optionalArgs, 1000);
    }

    private static Map adjustOutputMap(Object ret) {
        if (ret instanceof Map) {
            return (Map)ret;
        }
        if (ret != null && ret.getClass().isArray()) {
            JsonObject retMap = new JsonObject();
            retMap.put("@items", ret);
            return retMap;
        }
        JsonObject retMap = new JsonObject();
        retMap.put("@items", new Object[]{ret});
        return retMap;
    }

    public JsonReader(int maxDepth) {
        this.input = null;
        this.getArgs().put(USE_MAPS, false);
        this.getArgs().put(CLASSLOADER, JsonReader.class.getClassLoader());
        this.maxParseDepth = maxDepth;
    }

    public JsonReader() {
        this(1000);
    }

    public JsonReader(InputStream inp, int maxDepth) {
        this(inp, false, maxDepth);
    }

    public JsonReader(InputStream inp) {
        this(inp, 1000);
    }

    public JsonReader(Map<String, Object> optionalArgs, int maxDepth) {
        this((InputStream)new ByteArrayInputStream(new byte[0]), optionalArgs, maxDepth);
    }

    public JsonReader(Map<String, Object> optionalArgs) {
        this(optionalArgs, 1000);
    }

    static Map makeArgMap(Map<String, Object> args, boolean useMaps) {
        args.put(USE_MAPS, useMaps);
        return args;
    }

    public JsonReader(InputStream inp, boolean useMaps, int maxDepth) {
        this(inp, (Map<String, Object>)JsonReader.makeArgMap(new HashMap<String, Object>(), useMaps), maxDepth);
    }

    public JsonReader(InputStream inp, boolean useMaps) {
        this(inp, useMaps, 1000);
    }

    public JsonReader(InputStream inp, Map<String, Object> optionalArgs, int maxDepth) {
        this.initializeFromArgs(optionalArgs);
        this.input = new FastPushbackBufferedReader(new InputStreamReader(inp, StandardCharsets.UTF_8));
        this.maxParseDepth = maxDepth;
    }

    public JsonReader(InputStream inp, Map<String, Object> optionalArgs) {
        this(inp, optionalArgs, 1000);
    }

    public JsonReader(String inp, Map<String, Object> optionalArgs, int maxDepth) {
        this.initializeFromArgs(optionalArgs);
        byte[] bytes = inp.getBytes(StandardCharsets.UTF_8);
        this.input = new FastPushbackBufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), StandardCharsets.UTF_8));
        this.maxParseDepth = maxDepth;
    }

    public JsonReader(String inp, Map<String, Object> optionalArgs) {
        this(inp, optionalArgs, 1000);
    }

    public JsonReader(byte[] inp, Map<String, Object> optionalArgs, int maxDepth) {
        this.initializeFromArgs(optionalArgs);
        this.input = new FastPushbackBufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(inp), StandardCharsets.UTF_8));
        this.maxParseDepth = maxDepth;
    }

    public JsonReader(byte[] inp, Map<String, Object> optionalArgs) {
        this(inp, optionalArgs, 1000);
    }

    private void initializeFromArgs(Map<String, Object> optionalArgs) {
        Map factories;
        Collection notCustomReaders;
        Map typeNames;
        if (optionalArgs == null) {
            optionalArgs = new HashMap<String, Object>();
        }
        Map<String, Object> args = this.getArgs();
        args.putAll(optionalArgs);
        args.put(JSON_READER, this);
        if (!args.containsKey(CLASSLOADER)) {
            args.put(CLASSLOADER, JsonReader.class.getClassLoader());
        }
        if ((typeNames = (Map)args.get(TYPE_NAME_MAP)) != null) {
            HashMap typeNameMap = new HashMap();
            for (Map.Entry entry : typeNames.entrySet()) {
                typeNameMap.put(entry.getValue(), entry.getKey());
            }
            args.put(TYPE_NAME_MAP_REVERSE, typeNameMap);
        }
        this.setMissingFieldHandler((MissingFieldHandler)args.get(MISSING_FIELD_HANDLER));
        Map customReaders = (Map)args.get(CUSTOM_READER_MAP);
        if (customReaders != null) {
            this.readers.putAll(customReaders);
        }
        if ((notCustomReaders = (Collection)args.get(NOT_CUSTOM_READER_MAP)) != null) {
            this.notCustom.addAll(notCustomReaders);
        }
        if ((factories = (Map)args.get(FACTORIES)) != null) {
            this.classFactories.putAll(factories);
        }
    }

    public Object readObject() {
        Object graph;
        Object o;
        JsonParser parser = new JsonParser(this.input, this.getArgs(), this.maxParseDepth);
        JsonObject root = new JsonObject();
        try {
            o = parser.readValue(root);
            if (o == "~!o~") {
                return new JsonObject();
            }
        }
        catch (JsonIoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JsonIoException("error parsing JSON value", e);
        }
        if (o instanceof Object[]) {
            root.setType(Object[].class.getName());
            root.setTarget(o);
            root.put("@items", o);
            graph = this.convertParsedMapsToJava(root);
        } else {
            Object object = graph = o instanceof JsonObject ? this.convertParsedMapsToJava((JsonObject)o) : o;
        }
        if (this.useMaps()) {
            return o;
        }
        return graph;
    }

    public Object jsonObjectsToJava(JsonObject root) {
        this.getArgs().put(USE_MAPS, false);
        return this.convertParsedMapsToJava(root);
    }

    protected boolean useMaps() {
        return Boolean.TRUE.equals(this.getArgs().get(USE_MAPS));
    }

    ClassLoader getClassLoader() {
        return (ClassLoader)this.args.get(CLASSLOADER);
    }

    protected Object convertParsedMapsToJava(JsonObject root) {
        try {
            Object graph;
            if (root.isFinished) {
                graph = root.target;
            } else {
                Resolver resolver = this.useMaps() ? new MapResolver(this) : new ObjectResolver(this, (ClassLoader)this.args.get(CLASSLOADER));
                Object instance = resolver.createJavaObjectInstance(Object.class, root);
                graph = root.isFinished ? instance : resolver.convertMapsToObjects(root);
                resolver.cleanup();
                this.readers.clear();
                this.classFactories.clear();
            }
            return graph;
        }
        catch (Exception e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof JsonIoException) {
                throw (JsonIoException)e;
            }
            throw new JsonIoException(this.getErrorMessage(e.getMessage()), e);
        }
    }

    public Object newInstance(Class<?> c, JsonObject jsonObject) {
        ClassFactory classFactory = this.classFactories.get(c.getName());
        if (classFactory != null) {
            Object o = classFactory.newInstance(c, jsonObject);
            return jsonObject.setFinishedTarget(o, classFactory.isObjectFinal());
        }
        return MetaUtils.newInstance(c);
    }

    @Override
    public void close() {
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (Exception e) {
            throw new JsonIoException("Unable to close input", e);
        }
    }

    private String getErrorMessage(String msg) {
        if (this.input != null) {
            return msg + "\nLast read: " + this.input.getLastSnippet() + "\nline: " + this.input.getLine() + ", col: " + this.input.getCol();
        }
        return msg;
    }

    public void setMissingFieldHandler(MissingFieldHandler missingFieldHandler) {
        this.missingFieldHandler = missingFieldHandler;
    }

    MissingFieldHandler getMissingFieldHandler() {
        return this.missingFieldHandler;
    }

    public Map<String, Object> getArgs() {
        return this.args;
    }

    public static void setAllowNanAndInfinity(boolean allowNanAndInfinity) {
        JsonReader.allowNanAndInfinity = allowNanAndInfinity;
    }

    public static boolean isAllowNanAndInfinity() {
        return allowNanAndInfinity;
    }

    static {
        BASE_CLASS_FACTORIES = new ConcurrentHashMap<String, ClassFactory>();
        allowNanAndInfinity = false;
        MapFactory mapFactory = new MapFactory();
        JsonReader.assignInstantiator(Map.class, (ClassFactory)mapFactory);
        JsonReader.assignInstantiator(SortedMap.class, (ClassFactory)mapFactory);
        CollectionFactory colFactory = new CollectionFactory();
        JsonReader.assignInstantiator(Collection.class, (ClassFactory)colFactory);
        JsonReader.assignInstantiator(List.class, (ClassFactory)colFactory);
        JsonReader.assignInstantiator(Set.class, (ClassFactory)colFactory);
        JsonReader.assignInstantiator(SortedSet.class, (ClassFactory)colFactory);
        JsonReader.assignInstantiator(LocalDate.class, (ClassFactory)new LocalDateFactory());
        JsonReader.assignInstantiator(LocalTime.class, (ClassFactory)new LocalTimeFactory());
        JsonReader.assignInstantiator(LocalDateTime.class, (ClassFactory)new LocalDateTimeFactory());
        JsonReader.assignInstantiator(ZonedDateTime.class, (ClassFactory)new ZonedDateTimeFactory());
        TimeZoneFactory timeZoneFactory = new TimeZoneFactory();
        JsonReader.assignInstantiator(TimeZone.class, (ClassFactory)timeZoneFactory);
        JsonReader.assignInstantiator("sun.util.calendar.ZoneInfo", (ClassFactory)timeZoneFactory);
        HashMap temp = new HashMap();
        temp.put(String.class, new Readers.StringReader());
        temp.put(java.util.Date.class, new Readers.DateReader());
        temp.put(AtomicBoolean.class, new Readers.AtomicBooleanReader());
        temp.put(AtomicInteger.class, new Readers.AtomicIntegerReader());
        temp.put(AtomicLong.class, new Readers.AtomicLongReader());
        temp.put(BigInteger.class, new Readers.BigIntegerReader());
        temp.put(BigDecimal.class, new Readers.BigDecimalReader());
        temp.put(Date.class, new Readers.SqlDateReader());
        temp.put(Timestamp.class, new Readers.TimestampReader());
        temp.put(Calendar.class, new Readers.CalendarReader());
        temp.put(Locale.class, new Readers.LocaleReader());
        temp.put(Class.class, new Readers.ClassReader());
        temp.put(StringBuilder.class, new Readers.StringBuilderReader());
        temp.put(StringBuffer.class, new Readers.StringBufferReader());
        temp.put(UUID.class, new Readers.UUIDReader());
        temp.put(URL.class, new Readers.URLReader());
        temp.put(Enum.class, new Readers.EnumReader());
        JsonReader.addPossibleReader(temp, "java.lang.Record", Readers.RecordReader::new);
        BASE_READERS = temp;
    }

    public static class MapFactory
    implements ClassFactory {
        @Override
        public Object newInstance(Class<?> c, JsonObject job) {
            if (SortedMap.class.isAssignableFrom(c)) {
                return new TreeMap();
            }
            if (Map.class.isAssignableFrom(c)) {
                return new LinkedHashMap();
            }
            throw new JsonIoException("MapFactory handed Class for which it was not expecting: " + c.getName());
        }
    }

    public static class CollectionFactory
    implements ClassFactory {
        @Override
        public Object newInstance(Class<?> c, JsonObject job) {
            if (List.class.isAssignableFrom(c)) {
                return new ArrayList();
            }
            if (SortedSet.class.isAssignableFrom(c)) {
                return new TreeSet();
            }
            if (Set.class.isAssignableFrom(c)) {
                return new LinkedHashSet();
            }
            if (Collection.class.isAssignableFrom(c)) {
                return new ArrayList();
            }
            throw new JsonIoException("CollectionFactory handed Class for which it was not expecting: " + c.getName());
        }
    }

    public static interface JsonClassReaderEx
    extends JsonClassReader {

        public static class Support {
            public static JsonReader getReader(Map<String, Object> args) {
                return (JsonReader)args.get(JsonReader.JSON_READER);
            }
        }
    }

    public static interface JsonClassReader
    extends JsonClassReaderBase {
        default public Object read(Object jOb, Deque<JsonObject> stack, Map<String, Object> args, JsonReader reader) {
            return this.read(jOb, stack, args);
        }

        @Override
        default public Object read(Object jOb, Deque<JsonObject> stack, Map<String, Object> args) {
            return this.read(jOb, stack);
        }

        default public Object read(Object jOb, Deque<JsonObject> stack) {
            return null;
        }
    }

    public static interface JsonClassReaderBase {
        public Object read(Object var1, Deque<JsonObject> var2, Map<String, Object> var3);
    }

    public static interface MissingFieldHandler {
        public void fieldMissing(Object var1, String var2, Object var3);
    }

    public static interface ClassFactory {
        default public Object newInstance(Class<?> c, JsonObject job) {
            HashMap<String, JsonObject> args = new HashMap<String, JsonObject>();
            args.put("jsonObj", job);
            return this.newInstance(c, args);
        }

        default public Object setTarget(JsonObject job, Object o) {
            return job.setFinishedTarget(o, this.isObjectFinal());
        }

        @Deprecated
        default public Object newInstance(Class<?> c, Map args) {
            return this.newInstance(c);
        }

        @Deprecated
        default public Object newInstance(Class<?> c) {
            return MetaUtils.newInstance(c);
        }

        default public boolean isObjectFinal() {
            return false;
        }
    }
}

