/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io.factory;

import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.Readers;
import com.cedarsoftware.util.io.factory.AbstractTemporalFactory;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class LocalDateFactory
extends AbstractTemporalFactory<LocalDate> {
    public LocalDateFactory(DateTimeFormatter dateFormatter) {
        super(dateFormatter);
    }

    public LocalDateFactory() {
        super(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    @Override
    protected LocalDate fromString(String s) {
        try {
            return LocalDate.parse(s, this.dateTimeFormatter);
        }
        catch (Exception e) {
            Date date = Readers.DateReader.parseDate(s);
            return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }
    }

    @Override
    protected LocalDate fromNumber(Number l) {
        return LocalDate.ofEpochDay(l.longValue());
    }

    @Override
    protected LocalDate fromJsonObject(JsonObject job) {
        Number month = (Number)job.get("month");
        Number day = (Number)job.get("day");
        Number year = (Number)job.get("year");
        return LocalDate.of(year.intValue(), month.intValue(), day.intValue());
    }
}

