/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io.factory;

import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.ReaderContext;
import com.cedarsoftware.util.io.Readers;
import com.cedarsoftware.util.io.factory.AbstractTemporalFactory;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class ZonedDateTimeFactory
extends AbstractTemporalFactory<ZonedDateTime> {
    public ZonedDateTimeFactory(DateTimeFormatter dateFormatter) {
        super(dateFormatter);
    }

    public ZonedDateTimeFactory() {
        super(DateTimeFormatter.ISO_ZONED_DATE_TIME);
    }

    @Override
    protected ZonedDateTime fromString(String s) {
        try {
            return ZonedDateTime.parse(s, this.dateTimeFormatter);
        }
        catch (Exception e) {
            Date date = Readers.DateReader.parseDate(s);
            return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime().atZone(ZoneId.systemDefault());
        }
    }

    @Override
    protected ZonedDateTime fromJsonObject(JsonObject job) {
        String dateTime = (String)job.get("dateTime");
        LocalDateTime localDateTime = LocalDateTime.parse(dateTime, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        JsonObject zone = (JsonObject)job.get("zone");
        String id = (String)this.checkReferences(zone, "id");
        ZoneId zoneId = ZoneId.of(id);
        JsonObject offsetMap = (JsonObject)job.get("offset");
        Number totalSeconds = (Number)this.checkReferences(offsetMap, "totalSeconds");
        if (totalSeconds == null) {
            return ZonedDateTime.of(localDateTime, zoneId);
        }
        return ZonedDateTime.ofStrict(localDateTime, ZoneOffset.ofTotalSeconds(totalSeconds.intValue()), zoneId);
    }

    private <T> T checkReferences(JsonObject job, String key) {
        if (job == null) {
            return null;
        }
        return (T)ReaderContext.instance().getReferenceTracker().get(job).get(key);
    }
}

