/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonReader;
import com.cedarsoftware.io.MetaUtils;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReaderContext;
import com.cedarsoftware.io.ReferenceTracker;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.convert.Converter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class Resolver
implements ReaderContext {
    private static final String NO_FACTORY = "_\ufe3f_\u03c8_\u263c";
    final Collection<UnresolvedReference> unresolvedRefs = new ArrayList<UnresolvedReference>();
    final Map<Class<?>, Optional<JsonReader.JsonClassReader>> readerCache = new HashMap();
    private final Collection<Object[]> prettyMaps = new ArrayList<Object[]>();
    protected final Collection<Missingfields> missingFields = new ArrayList<Missingfields>();
    private final ReadOptions readOptions;
    private final ReferenceTracker references;
    private final Converter converter;

    @Override
    public ReadOptions getReadOptions() {
        return this.readOptions;
    }

    @Override
    public ReferenceTracker getReferences() {
        return this.references;
    }

    @Override
    public Converter getConverter() {
        return this.converter;
    }

    protected Resolver(ReadOptions readOptions, ReferenceTracker references, Converter converter) {
        this.readOptions = readOptions;
        this.references = references;
        this.converter = converter;
    }

    @Override
    public <T> T reentrantConvertJsonValueToJava(JsonObject rootObj, Class<T> root) {
        Object graph;
        if (rootObj == null) {
            return null;
        }
        if (rootObj.isReference()) {
            rootObj = this.getReferences().get(rootObj);
        }
        if (rootObj.isFinished) {
            graph = rootObj.getTarget();
        } else {
            rootObj.setHintType(root);
            Object instance = rootObj.getTarget() == null ? this.createInstance(rootObj) : rootObj.getTarget();
            graph = rootObj.isFinished ? instance : this.convertJsonValuesToJava(rootObj);
        }
        return (T)graph;
    }

    protected <T> T convertJsonValuesToJava(JsonObject root) {
        if (root.isFinished) {
            return (T)root.getTarget();
        }
        ArrayDeque<JsonObject> stack = new ArrayDeque<JsonObject>();
        stack.addFirst(root);
        while (!stack.isEmpty()) {
            JsonObject jsonObj = (JsonObject)stack.removeFirst();
            if (jsonObj.isFinished) continue;
            if (jsonObj.isArray()) {
                this.traverseArray(stack, jsonObj);
                continue;
            }
            if (jsonObj.isCollection()) {
                this.traverseCollection(stack, jsonObj);
                continue;
            }
            if (jsonObj.isMap()) {
                this.traverseMap(stack, jsonObj);
                continue;
            }
            Object special = this.readWithFactoryIfExists(jsonObj, null, stack);
            if (special != null) {
                jsonObj.setTarget(special);
                continue;
            }
            this.traverseFields(stack, jsonObj);
        }
        return (T)root.getTarget();
    }

    protected abstract Object readWithFactoryIfExists(Object var1, Class var2, Deque<JsonObject> var3);

    protected abstract void traverseCollection(Deque<JsonObject> var1, JsonObject var2);

    protected abstract void traverseArray(Deque<JsonObject> var1, JsonObject var2);

    protected void cleanup() {
        this.patchUnresolvedReferences();
        this.rehashMaps();
        if (this.references != null) {
            this.references.clear();
        }
        this.unresolvedRefs.clear();
        this.prettyMaps.clear();
        this.readerCache.clear();
        this.handleMissingFields();
    }

    private void handleMissingFields() {
        JsonReader.MissingFieldHandler missingFieldHandler = this.readOptions.getMissingFieldHandler();
        if (missingFieldHandler != null) {
            for (Missingfields mf : this.missingFields) {
                missingFieldHandler.fieldMissing(mf.target, mf.fieldName, mf.value);
            }
        }
    }

    protected void traverseMap(Deque<JsonObject> stack, JsonObject jsonObj) {
        Resolver.convertMapToKeysItems(jsonObj);
        Object[] keys = (Object[])jsonObj.get("@keys");
        Object[] items = jsonObj.getArray();
        if (keys == null || items == null) {
            if (keys != items) {
                throw new JsonIoException("Unbalanced Object in JSON, it has @keys or @items empty");
            }
            return;
        }
        int size = keys.length;
        if (size != items.length) {
            throw new JsonIoException("Map written with @keys and @itemss entries of different sizes");
        }
        Resolver.buildCollection(stack, keys);
        Resolver.buildCollection(stack, items);
        this.prettyMaps.add(new Object[]{jsonObj, keys, items});
    }

    private static void buildCollection(Deque<JsonObject> stack, Object[] arrayContent) {
        JsonObject collection = new JsonObject();
        collection.put("@items", arrayContent);
        collection.setTarget(arrayContent);
        stack.addFirst(collection);
    }

    protected static void convertMapToKeysItems(JsonObject jObj) {
        if (!jObj.containsKey("@keys") && !jObj.isReference()) {
            Object[] keys = new Object[jObj.size()];
            Object[] values = new Object[jObj.size()];
            int i = 0;
            Iterator<Map.Entry<Object, Object>> iterator = jObj.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> e;
                Map.Entry<Object, Object> entry = e = iterator.next();
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
            String saveType = jObj.getJavaTypeName();
            jObj.clear();
            jObj.setJavaType(ClassUtilities.forName((String)saveType, (ClassLoader)Resolver.class.getClassLoader()));
            jObj.put("@keys", keys);
            jObj.put("@items", values);
        }
    }

    protected Object createInstance(JsonObject jsonObj) {
        Object mate;
        Object target = jsonObj.getTarget();
        if (target != null) {
            return target;
        }
        Class<?> targetType = jsonObj.getJavaType();
        jsonObj.setJavaType(this.coerceClassIfNeeded(targetType));
        targetType = jsonObj.getJavaType();
        if (targetType == null) {
            System.out.println("targetType = " + targetType);
        }
        if (jsonObj.hasValue() && jsonObj.getValue() != null) {
            if (this.converter.isConversionSupportedFor(jsonObj.getValue().getClass(), targetType)) {
                Object value = this.getConverter().convert(jsonObj.getValue(), targetType);
                return jsonObj.setFinishedTarget(value, true);
            }
        } else if (targetType != null && MetaUtils.isLogicalPrimitive(targetType) && this.getConverter().isConversionSupportedFor(Map.class, targetType)) {
            JsonObject source = this.resolveRefs(jsonObj);
            Object value = this.getConverter().convert((Object)source, targetType);
            return jsonObj.setFinishedTarget(value, true);
        }
        if ((mate = this.createInstanceUsingClassFactory(jsonObj.getJavaType(), jsonObj)) != NO_FACTORY) {
            return mate;
        }
        Object mayEnumSpecial = jsonObj.get("@enum");
        if (mayEnumSpecial instanceof String) {
            Class clazz = ClassUtilities.forName((String)((String)mayEnumSpecial), (ClassLoader)Resolver.class.getClassLoader());
            mate = this.extractEnumSet(clazz, jsonObj);
            jsonObj.setTarget(mate);
            jsonObj.isFinished = true;
            return mate;
        }
        Class<?> c = jsonObj.getJavaType();
        Object[] items = jsonObj.getArray();
        if (c != null && (c.isArray() || items != null && c == Object.class && !jsonObj.containsKey("@keys"))) {
            int size = items == null ? 0 : items.length;
            mate = Array.newInstance(c.isArray() ? c.getComponentType() : Object.class, size);
            jsonObj.setTarget(mate);
            return mate;
        }
        return this.createInstanceUsingType(jsonObj);
    }

    protected Object createInstanceUsingType(JsonObject jsonObj) {
        Object mate;
        Class<?> c = jsonObj.getJavaType();
        boolean useMaps = this.readOptions.isReturningJsonObjects();
        if (c == Object.class && !useMaps) {
            Class<?> unknownClass = this.readOptions.getUnknownTypeClass();
            if (unknownClass == null) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.setJavaType(Map.class);
                mate = jsonObject;
            } else {
                mate = MetaUtils.newInstance(this.getConverter(), unknownClass, null);
            }
        } else {
            mate = MetaUtils.newInstance(this.getConverter(), c, null);
        }
        jsonObj.setTarget(mate);
        return mate;
    }

    Object createInstanceUsingClassFactory(Class c, JsonObject jsonObj) {
        JsonReader.ClassFactory classFactory = this.readOptions.getClassFactory(c);
        if (classFactory == null) {
            return NO_FACTORY;
        }
        Object target = classFactory.newInstance(c, jsonObj, this);
        if (classFactory.isObjectFinal()) {
            return jsonObj.setFinishedTarget(target, true);
        }
        jsonObj.setTarget(target);
        return target;
    }

    protected Class<?> coerceClassIfNeeded(Class<?> type) {
        if (type == null) {
            return null;
        }
        Class<?> clazz = this.readOptions.getCoercedClass(type);
        return clazz == null ? type : clazz;
    }

    protected EnumSet<?> extractEnumSet(Class c, JsonObject jsonObj) {
        String enumClassName = (String)jsonObj.get("@enum");
        Class enumClass = enumClassName == null ? null : ClassUtilities.forName((String)enumClassName, (ClassLoader)this.readOptions.getClassLoader());
        Object[] items = jsonObj.getArray();
        if (items == null || items.length == 0) {
            if (enumClass != null) {
                return EnumSet.noneOf(enumClass);
            }
            return EnumSet.noneOf(MetaUtils.Dumpty.class);
        }
        if (enumClass == null) {
            throw new JsonIoException("Could not figure out Enum of the not empty set " + jsonObj);
        }
        EnumSet enumSet = null;
        for (Object item : items) {
            Object enumItem;
            if (item instanceof String) {
                enumItem = Enum.valueOf(enumClass, (String)item);
            } else {
                JsonObject jObj = (JsonObject)item;
                enumItem = Enum.valueOf(enumClass, (String)jObj.get("name"));
            }
            if (enumSet == null) {
                enumSet = EnumSet.of(enumItem);
                continue;
            }
            enumSet.add(enumItem);
        }
        return enumSet;
    }

    protected void patchUnresolvedReferences() {
        for (UnresolvedReference ref : this.unresolvedRefs) {
            Object objToFix = ref.referencingObj.getTarget();
            JsonObject objReferenced = this.references.get(ref.refId);
            if (ref.index >= 0) {
                if (objToFix instanceof List) {
                    List<Object> list = (List<Object>)objToFix;
                    list.set(ref.index, objReferenced.getTarget());
                    String containingTypeName = ref.referencingObj.getJavaTypeName();
                    if (containingTypeName == null || !containingTypeName.startsWith("java.util.Immutable") || !containingTypeName.contains("List") || !list.stream().noneMatch(c -> c == null || c instanceof JsonObject)) continue;
                    list = MetaUtils.listOf(list.toArray());
                    ref.referencingObj.setTarget(list);
                    continue;
                }
                if (objToFix instanceof Collection) {
                    String containingTypeName = ref.referencingObj.getJavaTypeName();
                    Collection col = (Collection)objToFix;
                    if (containingTypeName != null && containingTypeName.startsWith("java.util.Immutable") && containingTypeName.contains("Set")) {
                        throw new JsonIoException("Error setting set entry of ImmutableSet '" + ref.referencingObj.getJavaTypeName() + "', @ref = " + ref.refId);
                    }
                    col.add(objReferenced.getTarget());
                    continue;
                }
                Array.set(objToFix, ref.index, objReferenced.getTarget());
                continue;
            }
            Field field = this.getReadOptions().getDeepDeclaredFields(objToFix.getClass()).get(ref.field);
            if (field == null) continue;
            try {
                MetaUtils.setFieldValue(field, objToFix, objReferenced.getTarget());
            }
            catch (Exception e) {
                throw new JsonIoException("Error setting field while resolving references '" + field.getName() + "', @ref = " + ref.refId, e);
            }
        }
        this.unresolvedRefs.clear();
    }

    protected void rehashMaps() {
        boolean useMapsLocal = this.readOptions.isReturningJsonObjects();
        for (Object[] mapPieces : this.prettyMaps) {
            Object[] javaValues;
            Object[] javaKeys;
            Map<Object, Object> map;
            JsonObject jObj = (JsonObject)mapPieces[0];
            if (useMapsLocal) {
                map = jObj;
                javaKeys = (Object[])jObj.remove("@keys");
                javaValues = (Object[])jObj.remove("@items");
            } else {
                map = (Map)jObj.getTarget();
                javaKeys = (Object[])mapPieces[1];
                javaValues = (Object[])mapPieces[2];
                jObj.clear();
            }
            for (int j = 0; javaKeys != null && j < javaKeys.length; ++j) {
                map.put(javaKeys[j], javaValues[j]);
            }
        }
    }

    protected JsonObject resolveRefs(JsonObject jsonObject) {
        JsonObject object = this.references.get(jsonObject);
        return object;
    }

    protected static class Missingfields {
        private Object target;
        private String fieldName;
        private Object value;

        public Missingfields(Object target, String fieldName, Object value) {
            this.target = target;
            this.fieldName = fieldName;
            this.value = value;
        }
    }

    static final class UnresolvedReference {
        private final JsonObject referencingObj;
        private String field;
        private final long refId;
        private int index = -1;

        UnresolvedReference(JsonObject referrer, String fld, long id) {
            this.referencingObj = referrer;
            this.field = fld;
            this.refId = id;
        }

        UnresolvedReference(JsonObject referrer, int idx, long id) {
            this.referencingObj = referrer;
            this.index = idx;
            this.refId = id;
        }
    }
}

