/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonValue;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class JsonObject
extends JsonValue
implements Map<Object, Object> {
    private final Map<Object, Object> jsonStore = new LinkedHashMap<Object, Object>();
    private boolean isMap = false;
    private Integer hash = null;

    public String toString() {
        String jType = this.javaType == null ? "not set" : this.javaType.getName();
        String targetInfo = this.target == null ? "null" : jType;
        return "JsonObject(id:" + this.id + ", type:" + jType + ", target:" + targetInfo + ", line:" + this.line + ", col:" + this.col + ", size:" + this.size() + ")";
    }

    @Override
    public Object setFinishedTarget(Object o, boolean isFinished) {
        this.setTarget(o);
        this.isFinished = isFinished;
        return this.target;
    }

    public boolean isMap() {
        return this.isMap || this.target instanceof Map;
    }

    public boolean isCollection() {
        if (this.target instanceof Collection) {
            return true;
        }
        if (this.containsKey("@items") && !this.containsKey("@keys")) {
            Class type = this.javaType;
            return type != null && !type.isArray();
        }
        return false;
    }

    @Override
    public boolean isArray() {
        if (this.target == null) {
            if (this.javaType != null) {
                return this.javaType.isArray();
            }
            return this.containsKey("@items") && !this.containsKey("@keys");
        }
        return this.target.getClass().isArray();
    }

    public Object[] getJsonArray() {
        return (Object[])this.get("@items");
    }

    public void setJsonArray(Object[] jsonArray) {
        this.put("@items", jsonArray);
    }

    public int getLength() {
        Integer items = this.getLenientSize();
        if (items != null) {
            return items;
        }
        throw new JsonIoException("getLength() called on a non-collection, line " + this.line + ", col " + this.col);
    }

    private Integer getLenientSize() {
        if (this.isArray()) {
            if (this.target == null) {
                Object[] items = this.getJsonArray();
                return items == null ? 0 : items.length;
            }
            if (char[].class.isAssignableFrom(this.target.getClass())) {
                return 1;
            }
            return Array.getLength(this.target);
        }
        if (this.isCollection() || this.isMap()) {
            Object[] items = this.getJsonArray();
            return items == null ? 0 : items.length;
        }
        return null;
    }

    public void setValue(Object o) {
        this.put("value", o);
    }

    public Object getValue() {
        return this.get("value");
    }

    public boolean hasValue() {
        return this.containsKey("value") && this.size() == 1;
    }

    @Override
    public int size() {
        if (this.containsKey("@items")) {
            if (this.getJsonArray() == null) {
                return 0;
            }
            return this.getJsonArray().length;
        }
        return this.jsonStore.size();
    }

    private int hashCode(Object array, Map<Object, Integer> seen) {
        if (array == null) {
            return super.hashCode();
        }
        if (!array.getClass().isArray()) {
            return super.hashCode();
        }
        if (seen.containsKey(array)) {
            return this.hash;
        }
        seen.put(array, null);
        int result = 1;
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object item = Array.get(array, i);
            this.hash = this.hashCode(item, seen);
            result = 31 * result + this.hash;
        }
        seen.remove(array);
        return result;
    }

    @Override
    public int hashCode() {
        if (this.hash == null) {
            this.hash = this.isArray() || this.isCollection() ? Integer.valueOf(this.hashCode(this.getJsonArray(), new IdentityHashMap<Object, Integer>())) : Integer.valueOf(this.jsonStore.hashCode());
        }
        return this.hash;
    }

    @Override
    public boolean isEmpty() {
        return this.jsonStore.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.jsonStore.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.jsonStore.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.jsonStore.get(key);
    }

    @Override
    public Object remove(Object key) {
        this.hash = null;
        return this.jsonStore.remove(key);
    }

    @Override
    public Object put(Object key, Object value) {
        this.hash = null;
        if ("@items".equals(key) && this.containsKey("@keys") || "@keys".equals(key) && this.containsKey("@items")) {
            this.isMap = true;
        }
        return this.jsonStore.put(key, value);
    }

    @Override
    public void putAll(Map<?, ?> map) {
        this.hash = null;
        this.jsonStore.putAll(map);
    }

    @Override
    public void clear() {
        super.clear();
        this.jsonStore.clear();
        this.hash = null;
    }

    @Override
    public Set<Object> keySet() {
        return this.jsonStore.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.jsonStore.values();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.jsonStore.entrySet();
    }

    Map.Entry<Object[], Object[]> asTwoArrays() {
        if (!this.containsKey("@keys") && !this.isReference()) {
            Object[] keys = new Object[this.size()];
            Object[] values = new Object[this.size()];
            int i = 0;
            Iterator<Map.Entry<Object, Object>> iterator = this.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> e;
                Map.Entry<Object, Object> entry = e = iterator.next();
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
            this.put("@keys", keys);
            this.put("@items", values);
        }
        return new AbstractMap.SimpleImmutableEntry<Object[], Object[]>((Object[])this.get("@keys"), (Object[])this.get("@items"));
    }

    void rehashMaps(boolean useMapsLocal, Object[] keys, Object[] items) {
        Object[] javaValues;
        Object[] javaKeys;
        Map<Object, Object> map;
        if (useMapsLocal) {
            map = this;
            javaKeys = (Object[])this.remove("@keys");
            javaValues = (Object[])this.remove("@items");
        } else {
            map = (Map)this.target;
            javaKeys = keys;
            javaValues = items;
        }
        this.jsonStore.clear();
        this.hash = null;
        int len = javaKeys.length;
        for (int i = 0; i < len; ++i) {
            map.put(javaKeys[i], javaValues[i]);
        }
    }
}

