/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonValue;
import com.cedarsoftware.util.CompactLinkedMap;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class JsonObject
extends JsonValue
implements Map<Object, Object> {
    private final Map<Object, Object> jsonStore = new CompactLinkedMap();
    private Integer hash = null;
    private Object items;
    private Object keys;

    public String toString() {
        String jType = this.javaType == null ? "not set" : this.javaType.getName();
        String targetInfo = this.target == null ? "null" : jType;
        return "JsonObject(id:" + this.id + ", type:" + jType + ", target:" + targetInfo + ", line:" + this.line + ", col:" + this.col + ", size:" + this.size() + ")";
    }

    public boolean isMap() {
        return this.target instanceof Map || this.javaType != null && Map.class.isAssignableFrom(this.javaType);
    }

    public boolean isCollection() {
        if (this.target instanceof Collection) {
            return true;
        }
        if (this.isMap()) {
            return false;
        }
        if (this.items != null && this.keys == null) {
            Class type = this.javaType;
            return type != null && !type.isArray();
        }
        return false;
    }

    @Override
    public boolean isArray() {
        if (this.target == null) {
            if (this.javaType != null) {
                return this.javaType.isArray();
            }
            return this.items != null && this.keys == null;
        }
        return this.target.getClass().isArray();
    }

    public Object getItems() {
        return this.items;
    }

    void setItems(Object array) {
        if (array == null) {
            throw new JsonIoException("Argument array cannot be null");
        }
        if (!array.getClass().isArray()) {
            throw new JsonIoException("Argument array must be an array, type: " + array.getClass().getName());
        }
        this.items = array;
        this.hash = null;
    }

    public Object getKeys() {
        return this.keys;
    }

    void setKeys(Object keys) {
        if (keys == null) {
            throw new JsonIoException("Argument 'keys' cannot be null");
        }
        if (!keys.getClass().isArray()) {
            throw new JsonIoException("Argument 'keys' must be an array, type: " + keys.getClass().getName());
        }
        this.keys = keys;
        this.hash = null;
    }

    @Override
    public int size() {
        if (this.items != null) {
            return Array.getLength(this.items);
        }
        return this.jsonStore.size();
    }

    @Deprecated
    public int getLength() {
        return this.size();
    }

    public void setValue(Object o) {
        this.put("value", o);
        this.hash = null;
    }

    public Object getValue() {
        return this.get("value");
    }

    public boolean hasValue() {
        return this.containsKey("value") && this.size() == 1;
    }

    @Override
    public int hashCode() {
        if (this.hash == null) {
            int result = 1;
            if (this.keys != null) {
                result = 31 * result + this.hashCode(this.keys, new IdentityHashMap<Object, Integer>());
            }
            if (this.items != null) {
                result = 31 * result + this.hashCode(this.items, new IdentityHashMap<Object, Integer>());
            }
            if (!this.jsonStore.isEmpty()) {
                result = 31 * result + this.jsonStore.hashCode();
            }
            this.hash = result;
        }
        return this.hash;
    }

    private int hashCode(Object array, Map<Object, Integer> seen) {
        if (array == null) {
            return 1;
        }
        if (!array.getClass().isArray()) {
            return array.hashCode();
        }
        Integer cachedHash = seen.get(array);
        if (cachedHash != null) {
            return cachedHash;
        }
        seen.put(array, null);
        int result = 1;
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object item = Array.get(array, i);
            result = 31 * result + this.hashCode(item, seen);
        }
        seen.put(array, result);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonObject)) {
            return false;
        }
        JsonObject other = (JsonObject)obj;
        if (!Arrays.deepEquals(new Object[]{this.items}, new Object[]{other.items})) {
            return false;
        }
        if (!Arrays.deepEquals(new Object[]{this.keys}, new Object[]{other.keys})) {
            return false;
        }
        return this.jsonStore.equals(other.jsonStore);
    }

    @Override
    public boolean isEmpty() {
        return this.size() < 1;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.jsonStore.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.jsonStore.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.jsonStore.get(key);
    }

    @Override
    public Object remove(Object key) {
        this.hash = null;
        return this.jsonStore.remove(key);
    }

    @Override
    public Object put(Object key, Object value) {
        this.hash = null;
        return this.jsonStore.put(key, value);
    }

    @Override
    public void putAll(Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.jsonStore.clear();
        this.items = null;
        this.keys = null;
        this.hash = null;
    }

    @Override
    public Set<Object> keySet() {
        return this.jsonStore.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.jsonStore.values();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.jsonStore.entrySet();
    }

    Map.Entry<Object, Object> asTwoArrays() {
        if (this.keys == null && this.items == null && !this.isReference()) {
            Object[] newKeys = new Object[this.jsonStore.size()];
            Object[] newValues = new Object[this.jsonStore.size()];
            int i = 0;
            for (Map.Entry<Object, Object> entry : this.jsonStore.entrySet()) {
                newKeys[i] = entry.getKey();
                newValues[i] = entry.getValue();
                ++i;
            }
            this.setKeys(newKeys);
            this.setItems(newValues);
            this.jsonStore.clear();
            return new AbstractMap.SimpleImmutableEntry<Object[], Object[]>(newKeys, newValues);
        }
        if (this.keys == null && this.items != null || this.keys != null && this.items == null) {
            throw new JsonIoException("@keys or @items cannot be empty if the other is not empty");
        }
        if (this.keys != null && this.items != null && Array.getLength(this.keys) != Array.getLength(this.items)) {
            throw new JsonIoException("@keys and @items must be same length");
        }
        return new AbstractMap.SimpleImmutableEntry<Object, Object>(this.keys, this.items);
    }

    void rehashMaps() {
        Map targetMap = (Map)this.target;
        this.hash = null;
        int len = Array.getLength(this.keys);
        for (int i = 0; i < len; ++i) {
            Object key = Array.get(this.keys, i);
            Object value = Array.get(this.items, i);
            this.put(key, value);
            if (targetMap == null) continue;
            targetMap.put(key, value);
        }
        this.keys = null;
        this.items = null;
    }
}

