/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonParser;
import com.cedarsoftware.io.MapResolver;
import com.cedarsoftware.io.ObjectResolver;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReadOptionsBuilder;
import com.cedarsoftware.io.ReferenceTracker;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.ExceptionUtilities;
import com.cedarsoftware.util.FastByteArrayInputStream;
import com.cedarsoftware.util.FastReader;
import com.cedarsoftware.util.convert.Converter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class JsonReader
implements Closeable {
    private final FastReader input;
    private final Resolver resolver;
    private final ReadOptions readOptions;
    private final JsonParser parser;
    private final Converter localConverter;
    private final boolean isRoot;

    protected FastReader getReader(InputStream inputStream) {
        return new FastReader((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8), 65536, 10);
    }

    public JsonReader(InputStream input, ReadOptions readOptions) {
        this(input, readOptions, new DefaultReferenceTracker());
    }

    public JsonReader(InputStream inputStream, ReadOptions readOptions, ReferenceTracker references) {
        this.isRoot = true;
        this.readOptions = readOptions == null ? ReadOptionsBuilder.getDefaultReadOptions() : readOptions;
        Converter converter = new Converter(this.readOptions.getConverterOptions());
        this.input = this.getReader(inputStream);
        this.resolver = this.readOptions.isReturningJsonObjects() ? new MapResolver(this.readOptions, references, converter) : new ObjectResolver(this.readOptions, references, converter);
        this.parser = new JsonParser(this.input, this.resolver);
        this.localConverter = new Converter(this.readOptions.getConverterOptions());
    }

    public JsonReader(ReadOptions readOptions) {
        this((InputStream)new FastByteArrayInputStream(new byte[0]), readOptions);
    }

    public JsonReader(Resolver resolver) {
        this.isRoot = false;
        this.resolver = resolver;
        this.readOptions = resolver.getReadOptions();
        this.localConverter = resolver.getConverter();
        this.input = this.getReader(new ByteArrayInputStream(new byte[0]));
        this.parser = new JsonParser(this.input, resolver);
    }

    public <T> T readObject(Class<T> rootType) {
        Object returnValue;
        this.verifyRootType(rootType);
        try {
            returnValue = this.parser.readValue(rootType);
        }
        catch (JsonIoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JsonIoException(this.getErrorMessage("error parsing JSON value"), e);
        }
        return (T)this.toJava(rootType, returnValue);
    }

    public Object toJava(Class<?> rootType, Object root) {
        if (root == null) {
            return null;
        }
        boolean isJava = this.resolver.getReadOptions().isReturningJavaObjects();
        if (this.isRootArray(root)) {
            Object o = this.handleArrayRoot(rootType, root);
            if (isJava && o instanceof JsonObject && ((JsonObject)o).target != null) {
                o = ((JsonObject)o).target;
            }
            return o;
        }
        if (root instanceof JsonObject) {
            Object o = this.handleObjectRoot(rootType, root);
            if (isJava && o instanceof JsonObject && ((JsonObject)o).target != null) {
                o = ((JsonObject)o).target;
            }
            return o;
        }
        return this.convertIfNeeded(rootType, root);
    }

    private boolean isRootArray(Object value) {
        if (value.getClass().isArray()) {
            return true;
        }
        return value instanceof JsonObject && ((JsonObject)value).isArray();
    }

    private Object handleArrayRoot(Class<?> rootType, Object returnValue) {
        JsonObject rootObj;
        if (returnValue.getClass().isArray()) {
            rootObj = new JsonObject();
            rootObj.setTarget(returnValue);
            rootObj.setItems(returnValue);
        } else {
            rootObj = (JsonObject)returnValue;
        }
        Object graph = this.resolveObjects(rootObj, rootType);
        if (graph == null) {
            graph = rootObj.getItems();
        }
        return this.convertIfNeeded(rootType, graph);
    }

    private Object convertIfNeeded(Class<?> rootType, Object returnValue) {
        if (rootType == null) {
            return returnValue;
        }
        if (rootType.isAssignableFrom(returnValue.getClass())) {
            return returnValue;
        }
        if (this.localConverter.isConversionSupportedFor(returnValue.getClass(), rootType)) {
            return this.localConverter.convert(returnValue, rootType);
        }
        throw new ClassCastException(this.getErrorMessage("Return type mismatch, expected: " + rootType.getName() + ", actual: " + returnValue.getClass().getName()));
    }

    private <T> void verifyRootType(Class<T> rootType) {
        if (rootType == null || this.readOptions.isReturningJavaObjects()) {
            return;
        }
        Class<Object> typeToCheck = rootType;
        if (rootType.isArray()) {
            while (typeToCheck.isArray()) {
                typeToCheck = typeToCheck.getComponentType();
            }
            if (this.localConverter.isSimpleTypeConversionSupported(typeToCheck, typeToCheck) || typeToCheck == Object.class) {
                return;
            }
        }
        if (this.localConverter.isSimpleTypeConversionSupported(typeToCheck, typeToCheck)) {
            return;
        }
        if (Collection.class.isAssignableFrom(typeToCheck)) {
            return;
        }
        if (Map.class.isAssignableFrom(typeToCheck)) {
            return;
        }
        throw new JsonIoException("In readOptions.isReturningJsonObjects() mode, the rootType '" + rootType.getName() + "' is not supported. Allowed types are:\n- null\n- primitive types (e.g., int, boolean) and their wrapper classes (e.g., Integer, Boolean)\n- types supported by Converter.convert()\n- Map or any of its subclasses\n- Collection or any of its subclasses\n- Arrays (of any depth) of the above types\nPlease use one of these types as the rootType, or enable readOptions.isReturningJavaObjects().");
    }

    private Object handleObjectRoot(Class<?> rootType, Object returnValue) {
        Object graph;
        JsonObject jObj;
        boolean returnJson = this.readOptions.isReturningJsonObjects();
        if (this.shouldFallbackToDefaultType(returnJson, rootType, (jObj = (JsonObject)returnValue).getJavaType())) {
            Class<?> fallbackType = this.getFallbackType(jObj.getJavaType());
            jObj.setJavaType(fallbackType);
        }
        if ((graph = this.resolveObjects(jObj, rootType)) == null) {
            return returnValue;
        }
        if (rootType != null) {
            if (rootType.isAssignableFrom(graph.getClass())) {
                return graph;
            }
            if (this.localConverter.isConversionSupportedFor(graph.getClass(), rootType)) {
                return this.localConverter.convert(graph, rootType);
            }
            HashSet<Class<Cloneable>> skipRoots = new HashSet<Class<Cloneable>>();
            skipRoots.add(Object.class);
            skipRoots.add(Serializable.class);
            skipRoots.add(Cloneable.class);
            Set commonAncestors = ClassUtilities.findLowestCommonSupertypesExcluding(graph.getClass(), rootType, skipRoots);
            if (commonAncestors.isEmpty()) {
                throw new ClassCastException("Return type mismatch, expected: " + rootType.getName() + ", actual: " + graph.getClass().getName());
            }
            return graph;
        }
        if (returnJson) {
            Class<?> javaType = jObj.getJavaType();
            if (javaType != null) {
                if (this.localConverter.isSimpleTypeConversionSupported(javaType, javaType) || Number.class.isAssignableFrom(javaType)) {
                    Class<?> basicType = this.getJsonSynonymType(javaType);
                    return this.localConverter.convert(returnValue, basicType);
                }
                if (!this.isBuiltInPrimitive(graph)) {
                    return returnValue;
                }
            }
            if (this.localConverter.isSimpleTypeConversionSupported(graph.getClass(), graph.getClass())) {
                return graph;
            }
            return returnValue;
        }
        return graph;
    }

    private boolean shouldFallbackToDefaultType(boolean returnJson, Class<?> rootType, Class<?> javaType) {
        return returnJson && rootType == null && javaType != null && this.getFallbackType(javaType) != null;
    }

    private Class<?> getFallbackType(Class<?> javaType) {
        if (SortedSet.class.isAssignableFrom(javaType)) {
            return LinkedHashSet.class;
        }
        if (SortedMap.class.isAssignableFrom(javaType)) {
            return LinkedHashMap.class;
        }
        return null;
    }

    private Class<?> getJsonSynonymType(Class<?> javaType) {
        if (javaType == StringBuilder.class || javaType == StringBuffer.class) {
            return String.class;
        }
        if (javaType == AtomicInteger.class) {
            return Integer.class;
        }
        if (javaType == AtomicLong.class) {
            return Long.class;
        }
        if (javaType == AtomicBoolean.class) {
            return Boolean.class;
        }
        return javaType;
    }

    private boolean isBuiltInPrimitive(Object obj) {
        if (obj == null) {
            return false;
        }
        Class<?> cls = obj.getClass();
        return this.localConverter.isSimpleTypeConversionSupported(cls, cls);
    }

    protected <T> T resolveObjects(JsonObject rootObj, Class<T> rootType) {
        try {
            T value;
            if (rootType == null) {
                rootType = rootObj.getJavaType() == null ? Object.class : rootObj.getJavaType();
            }
            T t = value = this.resolver.toJavaObjects(rootObj, rootType);
            return t;
        }
        catch (Exception e) {
            if (this.readOptions.isCloseStream()) {
                ExceptionUtilities.safelyIgnoreException(this::close);
            }
            if (e instanceof JsonIoException) {
                throw (JsonIoException)e;
            }
            throw new JsonIoException(this.getErrorMessage(e.getMessage()), e);
        }
        finally {
            if (this.isRoot) {
                this.resolver.cleanup();
            }
        }
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    @Override
    public void close() {
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (Exception e) {
            throw new JsonIoException("Unable to close input", e);
        }
    }

    private String getErrorMessage(String msg) {
        if (this.input != null) {
            return msg + "\nLast read: " + this.input.getLastSnippet() + "\nline: " + this.input.getLine() + ", col: " + this.input.getCol();
        }
        return msg;
    }

    static class DefaultReferenceTracker
    implements ReferenceTracker {
        final Map<Long, JsonObject> references = new HashMap<Long, JsonObject>();

        DefaultReferenceTracker() {
        }

        @Override
        public JsonObject put(Long l, JsonObject o) {
            return this.references.put(l, o);
        }

        @Override
        public void clear() {
            this.references.clear();
        }

        @Override
        public int size() {
            return this.references.size();
        }

        @Override
        public JsonObject getOrThrow(Long id) {
            JsonObject target = this.get(id);
            if (target == null) {
                throw new JsonIoException("Forward reference @ref: " + id + ", but no object defined (@id) with that value");
            }
            return target;
        }

        @Override
        public JsonObject get(Long id) {
            JsonObject target = this.references.get(id);
            if (target == null) {
                return null;
            }
            while (target.isReference()) {
                id = target.getReferenceId();
                if ((target = this.references.get(id)) != null) continue;
                return null;
            }
            return target;
        }
    }

    public static interface JsonClassReader {
        default public Object read(Object jsonObj, Resolver resolver) {
            throw new UnsupportedOperationException("You must implement this method and read the JSON content from jsonObj and copy the values from jsonObj to the target class, jsonObj.getTarget()");
        }
    }

    public static interface MissingFieldHandler {
        public void fieldMissing(Object var1, String var2, Object var3);
    }

    public static interface ClassFactory {
        default public Object newInstance(Class<?> c, JsonObject jObj, Resolver resolver) {
            return ClassUtilities.newInstance((Converter)resolver.getConverter(), c, null);
        }

        default public boolean isObjectFinal() {
            return false;
        }

        default public void gatherRemainingValues(Resolver resolver, JsonObject jObj, List<Object> arguments, Set<String> excludedFields) {
            Convention.throwIfNull((Object)jObj, (String)"JsonObject cannot be null");
            for (Map.Entry<Object, Object> entry : jObj.entrySet()) {
                JsonObject sub;
                Object value;
                if (excludedFields.contains(entry.getKey().toString()) || entry.getValue() == null || !(entry.getValue() instanceof JsonObject) || (value = resolver.toJavaObjects(sub = (JsonObject)entry.getValue(), sub.getJavaType())) == null || sub.getJavaType() == null) continue;
                arguments.add(value);
            }
        }
    }
}

