/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.factory;

import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonReader;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.util.ReflectionUtils;
import com.cedarsoftware.util.SystemUtilities;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class RecordFactory
implements JsonReader.ClassFactory {
    private static final boolean JAVA_16_OR_ABOVE = SystemUtilities.isJavaVersionAtLeast((int)16, (int)0);

    @Override
    public Object newInstance(Class<?> c, JsonObject jsonObj, Resolver resolver) {
        if (!JAVA_16_OR_ABOVE) {
            throw new RuntimeException("Record de-serialization only works with java>=16.");
        }
        try {
            Object[] recordComponents;
            ArrayList<Class> lParameterTypes = new ArrayList<Class>(jsonObj.size());
            ArrayList<Object> lParameterValues = new ArrayList<Object>(jsonObj.size());
            Method getRecordComponents = ReflectionUtils.getMethod(Class.class, (String)"getRecordComponents", (Class[])new Class[0]);
            if (getRecordComponents == null) {
                throw new NoSuchMethodException("getRecordComponents");
            }
            for (Object recordComponent : recordComponents = (Object[])getRecordComponents.invoke(c, new Object[0])) {
                Class type = (Class)ReflectionUtils.call((Object)recordComponent, (String)"getType", (Object[])new Object[0]);
                lParameterTypes.add(type);
                String parameterName = (String)ReflectionUtils.call((Object)recordComponent, (String)"getName", (Object[])new Object[0]);
                JsonObject paramValueJsonObj = new JsonObject();
                paramValueJsonObj.setType(type);
                paramValueJsonObj.setValue(jsonObj.get(parameterName));
                if (resolver.valueToTarget(paramValueJsonObj)) {
                    lParameterValues.add(paramValueJsonObj.getTarget());
                    continue;
                }
                lParameterValues.add(paramValueJsonObj.getValue());
            }
            Constructor constructor = ReflectionUtils.getConstructor(c, (Class[])lParameterTypes.toArray(new Class[0]));
            if (constructor == null) {
                throw new NoSuchMethodException("record constructor not found");
            }
            return constructor.newInstance(lParameterValues.toArray(new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isObjectFinal() {
        return true;
    }

    public static class RecordReader
    implements JsonReader.JsonClassReader {
        @Override
        public Object read(Object o, Resolver resolver) {
            if (!JAVA_16_OR_ABOVE) {
                throw new RuntimeException("Record de-serialization only works with java>=16.");
            }
            try {
                Object[] recordComponents;
                JsonObject jsonObj = (JsonObject)o;
                ArrayList<Class> lParameterTypes = new ArrayList<Class>(jsonObj.size());
                ArrayList<Object> lParameterValues = new ArrayList<Object>(jsonObj.size());
                Class<?> c = jsonObj.getRawType();
                Method getRecordComponents = ReflectionUtils.getMethod(Class.class, (String)"getRecordComponents", (Class[])new Class[0]);
                if (getRecordComponents == null) {
                    throw new NoSuchMethodException("getRecordComponents");
                }
                for (Object recordComponent : recordComponents = (Object[])getRecordComponents.invoke(c, new Object[0])) {
                    Class type = (Class)ReflectionUtils.call((Object)recordComponent, (String)"getType", (Object[])new Object[0]);
                    lParameterTypes.add(type);
                    String parameterName = (String)ReflectionUtils.call((Object)recordComponent, (String)"getName", (Object[])new Object[0]);
                    JsonObject paramValueJsonObj = new JsonObject();
                    paramValueJsonObj.setType(type);
                    paramValueJsonObj.setValue(jsonObj.get(parameterName));
                    if (resolver.valueToTarget(paramValueJsonObj)) {
                        lParameterValues.add(paramValueJsonObj.getTarget());
                        continue;
                    }
                    lParameterValues.add(paramValueJsonObj.getValue());
                }
                Constructor constructor = ReflectionUtils.getConstructor(c, (Class[])lParameterTypes.toArray(new Class[0]));
                if (constructor == null) {
                    throw new NoSuchMethodException("record constructor not found");
                }
                return constructor.newInstance(lParameterValues.toArray(new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

