/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.util.TypeUtilities;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class JsonValue {
    public static final String KEYS = "@keys";
    public static final String ITEMS = "@items";
    public static final String ID = "@id";
    public static final String REF = "@ref";
    public static final String TYPE = "@type";
    public static final String ENUM = "@enum";
    public static final String SHORT_TYPE = "@t";
    public static final String SHORT_ITEMS = "@e";
    public static final String SHORT_KEYS = "@k";
    public static final String SHORT_ID = "@i";
    public static final String SHORT_REF = "@r";
    public static final String VALUE = "value";
    Type type = null;
    protected Object target = null;
    protected boolean isFinished = false;
    protected long id = -1L;
    protected Long refId = null;
    protected int line;
    protected int col;
    private static volatile int maxCacheSize = 1000;
    private static final Map<Type, Boolean> typeResolvedCache = new ConcurrentHashMap<Type, Boolean>(){

        @Override
        public Boolean put(Type key, Boolean value) {
            if (this.size() >= maxCacheSize) {
                this.clear();
            }
            return super.put(key, value);
        }
    };

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.col;
    }

    public boolean isReference() {
        return this.refId != null;
    }

    public Long getReferenceId() {
        return this.refId;
    }

    public void setReferenceId(Long id) {
        this.refId = id;
        this.isFinished = true;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public void setFinished() {
        this.isFinished = true;
    }

    public Object setTarget(Object target) {
        this.target = target;
        if (target != null) {
            this.setType(target.getClass());
        }
        return target;
    }

    public Object setFinishedTarget(Object o, boolean isFinished) {
        this.isFinished = isFinished;
        return this.setTarget(o);
    }

    public Object getTarget() {
        return this.target;
    }

    public abstract boolean isArray();

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        if (type == null) {
            return;
        }
        if (type == this.type || type.equals(this.type)) {
            return;
        }
        if (type == Object.class && this.type != null) {
            return;
        }
        Boolean isResolved = typeResolvedCache.computeIfAbsent(type, t -> !TypeUtilities.hasUnresolvedType((Type)t));
        if (!isResolved.booleanValue()) {
            throw new JsonIoException("Unresolved type: " + type);
        }
        this.type = type;
    }

    public Class<?> getRawType() {
        if (this.type == null) {
            return null;
        }
        return TypeUtilities.getRawClass((Type)this.type);
    }

    public String getRawTypeName() {
        if (this.type == null) {
            return null;
        }
        Class rawClass = TypeUtilities.getRawClass((Type)this.type);
        return rawClass != null ? rawClass.getName() : null;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public boolean hasId() {
        return this.id > 0L;
    }

    void clear() {
        this.id = -1L;
        this.type = null;
        this.refId = null;
    }

    @Deprecated
    String getJavaTypeName() {
        Class<?> rawType = this.getRawType();
        return rawType != null ? rawType.getName() : null;
    }

    @Deprecated
    public void setJavaType(Class<?> type) {
        this.setType(type);
    }

    @Deprecated
    public Class<?> getJavaType() {
        return this.getRawType();
    }

    public static void setMaxTypeResolutionCacheSize(int cacheSize) {
        if (cacheSize < 1) {
            throw new JsonIoException("Type resolution cache size must be at least 1, value: " + cacheSize);
        }
        maxCacheSize = cacheSize;
        typeResolvedCache.clear();
    }

    public static int getMaxTypeResolutionCacheSize() {
        return maxCacheSize;
    }

    public static int getTypeResolutionCacheSize() {
        return typeResolvedCache.size();
    }

    public static void clearTypeResolutionCache() {
        typeResolvedCache.clear();
    }
}

