/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.exceptions;

import com.consol.citrus.report.FailureStackElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class CitrusRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private List<FailureStackElement> failureStack = new ArrayList<FailureStackElement>();

    public CitrusRuntimeException() {
    }

    public CitrusRuntimeException(String message) {
        super(message);
    }

    public CitrusRuntimeException(Throwable cause) {
        super(cause);
    }

    public CitrusRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }

    @Override
    public String getMessage() {
        return super.getMessage() + this.getFailureStackAsString();
    }

    public String getFailureStackAsString() {
        StringBuilder builder = new StringBuilder();
        for (FailureStackElement failureStackElement : this.getFailureStack()) {
            builder.append("\n\t");
            builder.append(failureStackElement.getStackMessage());
        }
        return builder.toString();
    }

    public void setFailureStack(List<FailureStackElement> failureStack) {
        this.failureStack = failureStack;
    }

    public Stack<FailureStackElement> getFailureStack() {
        Stack<FailureStackElement> stack = new Stack<FailureStackElement>();
        for (FailureStackElement failureStackElement : this.failureStack) {
            stack.push(failureStackElement);
        }
        return stack;
    }
}

