/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.message;

import com.consol.citrus.message.Message;
import java.util.Map;

public final class MessageHeaderUtils {
    public static final String SEQUENCE_NUMBER = "sequenceNumber";
    public static final String SEQUENCE_SIZE = "sequenceSize";
    public static final String PRIORITY = "priority";

    private MessageHeaderUtils() {
    }

    public static boolean isSpringInternalHeader(String headerName) {
        if (headerName.startsWith("springintegration_")) {
            return true;
        }
        if (headerName.equals("id")) {
            return true;
        }
        if (headerName.equals("timestamp")) {
            return true;
        }
        if (headerName.equals("replyChannel")) {
            return true;
        }
        if (headerName.equals("errorChannel")) {
            return true;
        }
        if (headerName.equals("contentType")) {
            return true;
        }
        if (headerName.equals(PRIORITY)) {
            return true;
        }
        if (headerName.equals("correlationId")) {
            return true;
        }
        if (headerName.equals("routingSlip")) {
            return true;
        }
        if (headerName.equals("duplicateMessage")) {
            return true;
        }
        if (headerName.equals(SEQUENCE_NUMBER)) {
            return true;
        }
        if (headerName.equals(SEQUENCE_SIZE)) {
            return true;
        }
        if (headerName.equals("sequenceDetails")) {
            return true;
        }
        if (headerName.equals("expirationDate")) {
            return true;
        }
        return headerName.startsWith("jms_");
    }

    public static void setHeader(Message message, String name, String value) {
        if (name.equals(SEQUENCE_NUMBER)) {
            message.setHeader(SEQUENCE_NUMBER, Integer.valueOf(value));
        } else if (name.equals(SEQUENCE_SIZE)) {
            message.setHeader(SEQUENCE_SIZE, Integer.valueOf(value));
        } else if (name.equals(PRIORITY)) {
            message.setHeader(PRIORITY, Integer.valueOf(value));
        } else {
            message.setHeader(name, value);
        }
    }

    public static void checkHeaderTypes(Map<String, Object> headers) {
        String size;
        if (headers.containsKey(SEQUENCE_NUMBER)) {
            String number = headers.get(SEQUENCE_NUMBER).toString();
            headers.put(SEQUENCE_NUMBER, Integer.valueOf(number));
        }
        if (headers.containsKey(SEQUENCE_SIZE)) {
            size = headers.get(SEQUENCE_SIZE).toString();
            headers.put(SEQUENCE_SIZE, Integer.valueOf(size));
        }
        if (headers.containsKey(PRIORITY)) {
            size = headers.get(PRIORITY).toString();
            headers.put(PRIORITY, Integer.valueOf(size));
        }
    }
}

