/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.util;

import com.consol.citrus.CitrusSettings;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.util.TypeConverter;
import com.consol.citrus.xml.StringSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamSource;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Node;

public class DefaultTypeConverter
implements TypeConverter {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTypeConverter.class);
    public static DefaultTypeConverter INSTANCE = new DefaultTypeConverter();

    @Override
    public final <T> T convertIfNecessary(Object target, Class<T> type) {
        if (type.isInstance(target)) {
            return type.cast(target);
        }
        T result = this.convertBefore(target, type);
        if (result != null) {
            return result;
        }
        if (Source.class.isAssignableFrom(type)) {
            if (target.getClass().isAssignableFrom(String.class)) {
                return (T)new StringSource(String.valueOf(target));
            }
            if (target.getClass().isAssignableFrom(Node.class)) {
                return (T)new DOMSource((Node)target);
            }
            if (target.getClass().isAssignableFrom(InputStreamSource.class)) {
                try {
                    return (T)new StreamSource(((InputStreamSource)target).getInputStream());
                }
                catch (IOException e) {
                    LOG.warn("Failed to create stream source from object", (Throwable)e);
                }
            }
        }
        if (Map.class.isAssignableFrom(type)) {
            String mapString = String.valueOf(target);
            Properties props = new Properties();
            try {
                props.load(new StringReader(mapString.substring(1, mapString.length() - 1).replaceAll(",\\s*", "\n")));
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to reconstruct object of type map", e);
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                map.put(entry.getKey().toString(), entry.getValue());
            }
            return (T)map;
        }
        if (String[].class.isAssignableFrom(type)) {
            String arrayString = String.valueOf(target).replaceAll("^\\[", "").replaceAll("]$", "").replaceAll(",\\s", ",");
            return (T)StringUtils.commaDelimitedListToStringArray((String)arrayString);
        }
        if (List.class.isAssignableFrom(type)) {
            String listString = String.valueOf(target).replaceAll("^\\[", "").replaceAll("]$", "").replaceAll(",\\s", ",");
            return (T)Arrays.asList(StringUtils.commaDelimitedListToStringArray((String)listString));
        }
        if (byte[].class.isAssignableFrom(type)) {
            if (target instanceof String) {
                try {
                    return (T)String.valueOf(target).getBytes(CitrusSettings.CITRUS_FILE_ENCODING);
                }
                catch (UnsupportedEncodingException e) {
                    return (T)String.valueOf(target).getBytes();
                }
            }
            if (target instanceof ByteBuffer) {
                return (T)((ByteBuffer)target).array();
            }
            if (target instanceof ByteArrayInputStream) {
                try {
                    return (T)StreamUtils.copyToByteArray((InputStream)((ByteArrayInputStream)target));
                }
                catch (IOException e) {
                    throw new CitrusRuntimeException("Failed to convert input stream to byte[]");
                }
            }
        }
        if (InputStream.class.isAssignableFrom(type)) {
            if (target instanceof InputStream) {
                return (T)target;
            }
            if (target instanceof byte[]) {
                return (T)new ByteArrayInputStream((byte[])target);
            }
            if (target instanceof String) {
                try {
                    return (T)new ByteArrayInputStream(String.valueOf(target).getBytes(CitrusSettings.CITRUS_FILE_ENCODING));
                }
                catch (UnsupportedEncodingException e) {
                    return (T)new ByteArrayInputStream(String.valueOf(target).getBytes());
                }
            }
            try {
                return (T)new ByteArrayInputStream(target.toString().getBytes(CitrusSettings.CITRUS_FILE_ENCODING));
            }
            catch (UnsupportedEncodingException e) {
                return (T)new ByteArrayInputStream(target.toString().getBytes());
            }
        }
        if (type.equals(String.class)) {
            if (target == null) {
                return (T)"null";
            }
            if (ByteBuffer.class.isAssignableFrom(target.getClass())) {
                return (T)new String(((ByteBuffer)target).array());
            }
            if (short[].class.isAssignableFrom(target.getClass())) {
                return (T)Arrays.toString((short[])target);
            }
            if (int[].class.isAssignableFrom(target.getClass())) {
                return (T)Arrays.toString((int[])target);
            }
            if (long[].class.isAssignableFrom(target.getClass())) {
                return (T)Arrays.toString((long[])target);
            }
            if (float[].class.isAssignableFrom(target.getClass())) {
                return (T)Arrays.toString((float[])target);
            }
            if (double[].class.isAssignableFrom(target.getClass())) {
                return (T)Arrays.toString((double[])target);
            }
            if (char[].class.isAssignableFrom(target.getClass())) {
                return (T)Arrays.toString((char[])target);
            }
            if (boolean[].class.isAssignableFrom(target.getClass())) {
                return (T)Arrays.toString((boolean[])target);
            }
            if (Object[].class.isAssignableFrom(target.getClass())) {
                return (T)Arrays.toString((Object[])target);
            }
            if (String[].class.isAssignableFrom(target.getClass())) {
                return (T)Arrays.toString((String[])target);
            }
            if (List.class.isAssignableFrom(target.getClass()) || Map.class.isAssignableFrom(target.getClass())) {
                return (T)target.toString();
            }
            if (byte[].class.isAssignableFrom(target.getClass())) {
                return (T)Arrays.toString((byte[])target);
            }
        }
        if (target instanceof String) {
            try {
                return this.convertStringToType(String.valueOf(target), type);
            }
            catch (CitrusRuntimeException e) {
                LOG.warn(String.format("Unable to convert String object to type '%s' - try fallback strategies", type), (Throwable)e);
            }
        }
        if (target instanceof Number) {
            if (type.isAssignableFrom(Integer.TYPE) || type.isAssignableFrom(Integer.class)) {
                return (T)new Integer(((Number)target).intValue());
            }
            if (type.isAssignableFrom(Short.TYPE) || type.isAssignableFrom(Short.class)) {
                return (T)new Short(((Number)target).shortValue());
            }
            if (type.isAssignableFrom(Byte.TYPE) || type.isAssignableFrom(Byte.class)) {
                return (T)new Byte(((Number)target).byteValue());
            }
            if (type.isAssignableFrom(Long.TYPE) || type.isAssignableFrom(Long.class)) {
                return (T)new Long(((Number)target).longValue());
            }
            if (type.isAssignableFrom(Float.TYPE) || type.isAssignableFrom(Float.class)) {
                return (T)new Float(((Number)target).floatValue());
            }
            if (type.isAssignableFrom(Double.TYPE) || type.isAssignableFrom(Double.class)) {
                return (T)new Double(((Number)target).doubleValue());
            }
        }
        try {
            return this.convertAfter(target, type);
        }
        catch (Exception e) {
            if (String.class.equals(type)) {
                LOG.warn(String.format("Using default toString representation because object type conversion failed with: %s", e.getMessage()));
                return (T)target.toString();
            }
            throw e;
        }
    }

    @Override
    public <T> T convertStringToType(String value, Class<T> type) {
        if (type.isAssignableFrom(String.class)) {
            return (T)value;
        }
        if (type.isAssignableFrom(Integer.TYPE) || type.isAssignableFrom(Integer.class)) {
            return (T)Integer.valueOf(value);
        }
        if (type.isAssignableFrom(Short.TYPE) || type.isAssignableFrom(Short.class)) {
            return (T)Short.valueOf(value);
        }
        if (type.isAssignableFrom(Byte.TYPE) || type.isAssignableFrom(Byte.class)) {
            return (T)Byte.valueOf(value);
        }
        if (type.isAssignableFrom(Long.TYPE) || type.isAssignableFrom(Long.class)) {
            return (T)Long.valueOf(value);
        }
        if (type.isAssignableFrom(Boolean.TYPE) || type.isAssignableFrom(Boolean.class)) {
            return (T)Boolean.valueOf(value);
        }
        if (type.isAssignableFrom(Float.TYPE) || type.isAssignableFrom(Float.class)) {
            return (T)Float.valueOf(value);
        }
        if (type.isAssignableFrom(Double.TYPE) || type.isAssignableFrom(Double.class)) {
            return (T)Double.valueOf(value);
        }
        throw new CitrusRuntimeException(String.format("Unable to convert '%s' to required type '%s'", value, type.getName()));
    }

    protected <T> T convertBefore(Object target, Class<T> type) {
        return null;
    }

    protected <T> T convertAfter(Object target, Class<T> type) {
        if (String.class.equals(type)) {
            LOG.warn(String.format("Using default toString representation for object type %s", target.getClass()));
            return (T)target.toString();
        }
        throw new CitrusRuntimeException(String.format("Unable to convert object '%s' to target type '%s'", Optional.ofNullable(target).map(Object::getClass).map(Class::getName).orElse("null"), type));
    }
}

