/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.variable;

import com.consol.citrus.builder.WithExpressions;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageProcessor;
import com.consol.citrus.spi.ResourcePathTypeResolver;
import com.consol.citrus.spi.TypeResolver;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface VariableExtractor
extends MessageProcessor {
    public static final Logger LOG = LoggerFactory.getLogger(VariableExtractor.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/variable/extractor";
    public static final TypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/variable/extractor");

    public static <T extends VariableExtractor, B extends Builder<T, B>> Optional<Builder<T, B>> lookup(String extractor) {
        try {
            Builder instance = (Builder)TYPE_RESOLVER.resolve(extractor, new Object[0]);
            return Optional.of(instance);
        }
        catch (CitrusRuntimeException e) {
            LOG.warn(String.format("Failed to resolve variable extractor from resource '%s/%s'", RESOURCE_PATH, extractor));
            return Optional.empty();
        }
    }

    @Override
    default public void process(Message message, TestContext context) {
        this.extractVariables(message, context);
    }

    public void extractVariables(Message var1, TestContext var2);

    public static interface Builder<T extends VariableExtractor, B extends Builder<T, B>>
    extends MessageProcessor.Builder<T, B>,
    WithExpressions<B> {
        @Override
        public T build();
    }
}

