/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus;

import com.consol.citrus.CitrusSettings;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestCaseMetaInfo;
import com.consol.citrus.TestGroupAware;
import com.consol.citrus.TestParameterAware;
import com.consol.citrus.TestResult;
import com.consol.citrus.container.AbstractActionContainer;
import com.consol.citrus.container.AfterTest;
import com.consol.citrus.container.BeforeTest;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.TestCaseFailedException;
import com.consol.citrus.util.TestUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DefaultTestCase
extends AbstractActionContainer
implements TestCase,
TestGroupAware,
TestParameterAware {
    private List<TestActionBuilder<?>> finalActions = new ArrayList();
    private Map<String, Object> variableDefinitions = new LinkedHashMap<String, Object>();
    private TestCaseMetaInfo metaInfo = new TestCaseMetaInfo();
    private Class<?> testClass = this.getClass();
    private String packageName = this.getClass().getPackage().getName();
    private final Map<String, Object> parameters = new LinkedHashMap<String, Object>();
    private TestResult testResult;
    private boolean incremental = false;
    private String[] groups;
    private long timeout = 10000L;

    public void start(TestContext context) {
        context.getTestListeners().onTestStart((TestCase)this);
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Initializing test case");
            }
            this.debugVariables("Global", context);
            this.initializeTestParameters(this.parameters, context);
            this.initializeTestVariables(this.variableDefinitions, context);
            this.debugVariables("Test", context);
            this.beforeTest(context);
        }
        catch (AssertionError | Exception e) {
            this.testResult = TestResult.failed((String)this.getName(), (String)this.testClass.getName(), (Throwable)e);
            throw new TestCaseFailedException((Throwable)e);
        }
    }

    @Override
    public void doExecute(TestContext context) {
        if (!this.getMetaInfo().getStatus().equals((Object)TestCaseMetaInfo.Status.DISABLED)) {
            try {
                this.start(context);
                for (TestActionBuilder actionBuilder : this.actions) {
                    this.executeAction(actionBuilder.build(), context);
                }
                this.testResult = TestResult.success((String)this.getName(), (String)this.testClass.getName());
            }
            catch (TestCaseFailedException e) {
                throw e;
            }
            catch (AssertionError | Exception e) {
                this.testResult = TestResult.failed((String)this.getName(), (String)this.testClass.getName(), (Throwable)e);
                throw new TestCaseFailedException((Throwable)e);
            }
            finally {
                this.finish(context);
            }
        } else {
            this.testResult = TestResult.skipped((String)this.getName(), (String)this.testClass.getName());
            context.getTestListeners().onTestSkipped((TestCase)this);
        }
    }

    public void beforeTest(TestContext context) {
        for (BeforeTest sequenceBeforeTest : context.getBeforeTest()) {
            try {
                if (!sequenceBeforeTest.shouldExecute(this.getName(), this.packageName, this.groups)) continue;
                sequenceBeforeTest.execute(context);
            }
            catch (Exception e) {
                throw new CitrusRuntimeException("Before test failed with errors", (Throwable)e);
            }
        }
    }

    public void afterTest(TestContext context) {
        for (AfterTest sequenceAfterTest : context.getAfterTest()) {
            try {
                if (!sequenceAfterTest.shouldExecute(this.getName(), this.packageName, this.groups)) continue;
                sequenceAfterTest.execute(context);
            }
            catch (AssertionError | Exception e) {
                this.log.warn("After test failed with errors", (Throwable)e);
            }
        }
    }

    @Override
    public void executeAction(TestAction action, TestContext context) {
        if (context.hasExceptions()) {
            throw (CitrusRuntimeException)((Object)context.getExceptions().remove(0));
        }
        try {
            this.setActiveAction(action);
            if (!action.isDisabled(context)) {
                context.getTestActionListeners().onTestActionStart((TestCase)this, action);
                action.execute(context);
                context.getTestActionListeners().onTestActionFinish((TestCase)this, action);
            } else {
                context.getTestActionListeners().onTestActionSkipped((TestCase)this, action);
            }
        }
        catch (AssertionError | Exception e) {
            this.testResult = TestResult.failed((String)this.getName(), (String)this.testClass.getName(), (Throwable)e);
            throw new TestCaseFailedException((Throwable)e);
        }
        finally {
            this.setExecutedAction(action);
        }
    }

    public void finish(TestContext context) {
        try {
            CitrusRuntimeException contextException = null;
            if (this.testResult == null) {
                if (context.hasExceptions()) {
                    contextException = (CitrusRuntimeException)((Object)context.getExceptions().remove(0));
                    this.testResult = TestResult.failed((String)this.getName(), (String)this.testClass.getName(), (Throwable)contextException);
                } else {
                    this.testResult = TestResult.success((String)this.getName(), (String)this.testClass.getName());
                }
            }
            if (context.isSuccess(this.testResult)) {
                TestUtils.waitForCompletion(this, context, this.timeout);
            }
            context.getTestListeners().onTestFinish((TestCase)this);
            this.executeFinalActions(context);
            if (contextException != null) {
                throw new TestCaseFailedException((Throwable)contextException);
            }
        }
        catch (TestCaseFailedException e) {
            throw e;
        }
        catch (AssertionError | Exception e) {
            this.testResult = TestResult.failed((String)this.getName(), (String)this.testClass.getName(), (Throwable)e);
            throw new TestCaseFailedException((Throwable)e);
        }
        finally {
            if (this.testResult != null) {
                if (this.testResult.isSuccess()) {
                    context.getTestListeners().onTestSuccess((TestCase)this);
                } else {
                    context.getTestListeners().onTestFailure((TestCase)this, this.testResult.getCause());
                }
            }
            this.afterTest(context);
        }
    }

    private void executeFinalActions(TestContext context) {
        if (!this.finalActions.isEmpty()) {
            this.log.debug("Entering finally block in test case");
            for (TestActionBuilder<?> actionBuilder : this.finalActions) {
                TestAction action = actionBuilder.build();
                if (!action.isDisabled(context)) {
                    context.getTestActionListeners().onTestActionStart((TestCase)this, action);
                    action.execute(context);
                    context.getTestActionListeners().onTestActionFinish((TestCase)this, action);
                    continue;
                }
                context.getTestActionListeners().onTestActionSkipped((TestCase)this, action);
            }
        }
        if (this.testResult.isSuccess() && context.hasExceptions()) {
            CitrusRuntimeException contextException = (CitrusRuntimeException)((Object)context.getExceptions().remove(0));
            this.testResult = TestResult.failed((String)this.getName(), (String)this.testClass.getName(), (Throwable)contextException);
            throw new TestCaseFailedException((Throwable)contextException);
        }
    }

    private void debugVariables(String scope, TestContext context) {
        if (context.hasVariables() && this.log.isDebugEnabled()) {
            this.log.debug(String.format("%s variables:", scope));
            for (Map.Entry entry : context.getVariables().entrySet()) {
                this.log.debug(String.format("%s = %s", entry.getKey(), entry.getValue()));
            }
        }
    }

    private void initializeTestParameters(Map<String, Object> parameters, TestContext context) {
        context.setVariable(CitrusSettings.TEST_NAME_VARIABLE, (Object)this.getName());
        context.setVariable(CitrusSettings.TEST_PACKAGE_VARIABLE, (Object)this.packageName);
        for (Map.Entry<String, Object> paramEntry : parameters.entrySet()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("Initializing test parameter '%s' as variable", paramEntry.getKey()));
            }
            context.setVariable(paramEntry.getKey(), paramEntry.getValue());
        }
    }

    private void initializeTestVariables(Map<String, Object> variableDefinitions, TestContext context) {
        for (Map.Entry<String, Object> entry : variableDefinitions.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                context.setVariable(key, (Object)context.replaceDynamicContentInString(value.toString()));
                continue;
            }
            context.setVariable(key, value);
        }
    }

    public void setVariableDefinitions(Map<String, Object> variableDefinitions) {
        this.variableDefinitions = variableDefinitions;
    }

    public Map<String, Object> getVariableDefinitions() {
        return this.variableDefinitions;
    }

    public void setFinalActions(List<TestAction> finalActions) {
        this.finalActions = finalActions.stream().map(action -> () -> action).collect(Collectors.toList());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[testVariables:");
        for (Map.Entry<String, Object> entry : this.variableDefinitions.entrySet()) {
            stringBuilder.append(entry.getKey()).append("=").append(entry.getValue().toString()).append(";");
        }
        stringBuilder.append("] ");
        stringBuilder.append("[testActions:");
        for (TestActionBuilder actionBuilder : this.actions) {
            TestAction action = actionBuilder.build();
            stringBuilder.append(action.getClass().getName()).append(";");
        }
        stringBuilder.append("] ");
        return super.toString() + stringBuilder.toString();
    }

    public void addFinalAction(TestActionBuilder<?> testAction) {
        this.finalActions.add(testAction);
    }

    public TestCaseMetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public void setMetaInfo(TestCaseMetaInfo metaInfo) {
        this.metaInfo = metaInfo;
    }

    public List<TestAction> getFinalActions() {
        return this.finalActions.stream().map(TestActionBuilder::build).collect(Collectors.toList());
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setTestClass(Class<?> type) {
        this.testClass = type;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public void setParameters(String[] parameterNames, Object[] parameterValues) {
        if (parameterNames.length != parameterValues.length) {
            throw new CitrusRuntimeException(String.format("Invalid test parameter usage - received '%s' parameters with '%s' values", parameterNames.length, parameterValues.length));
        }
        for (int i = 0; i < parameterNames.length; ++i) {
            if (parameterValues[i] == null) continue;
            this.parameters.put(parameterNames[i], parameterValues[i]);
        }
    }

    public List<TestActionBuilder<?>> getActionBuilders() {
        return this.actions;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public void setTestResult(TestResult testResult) {
        this.testResult = testResult;
    }

    public TestResult getTestResult() {
        return this.testResult;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public void setGroups(String[] groups) {
        this.groups = groups;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }
}

