/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.AbstractTestActionBuilder;
import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoAction
extends AbstractTestAction {
    private final String message;
    private static Logger log = LoggerFactory.getLogger(EchoAction.class);

    private EchoAction(Builder builder) {
        super("echo", builder);
        this.message = builder.message;
    }

    @Override
    public void doExecute(TestContext context) {
        if (this.message == null) {
            log.info("Citrus test " + new Date(System.currentTimeMillis()));
        } else {
            log.info(context.getLogModifier().mask(context.replaceDynamicContentInString(this.message)));
        }
    }

    public String getMessage() {
        return this.message;
    }

    public static final class Builder
    extends AbstractTestActionBuilder<EchoAction, Builder> {
        private String message;

        public static Builder echo() {
            return new Builder();
        }

        public static Builder echo(String message) {
            Builder builder = new Builder();
            builder.message(message);
            return builder;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public EchoAction build() {
            return new EchoAction(this);
        }
    }
}

