/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.AbstractTestActionBuilder;
import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.exceptions.ActionTimeoutException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageSelectorBuilder;
import com.consol.citrus.messaging.Consumer;
import com.consol.citrus.messaging.SelectiveConsumer;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class PurgeEndpointAction
extends AbstractTestAction {
    private final List<String> endpointNames;
    private final List<Endpoint> endpoints;
    private final ReferenceResolver referenceResolver;
    private final Map<String, Object> messageSelectorMap;
    private final String messageSelector;
    private final long receiveTimeout;
    private final long sleepTime;
    private static Logger log = LoggerFactory.getLogger(PurgeEndpointAction.class);

    public PurgeEndpointAction(Builder builder) {
        super("purge-endpoint", builder);
        this.endpointNames = builder.endpointNames;
        this.endpoints = builder.endpoints;
        this.referenceResolver = builder.referenceResolver;
        this.messageSelector = builder.messageSelector;
        this.messageSelectorMap = builder.messageSelectorMap;
        this.receiveTimeout = builder.receiveTimeout;
        this.sleepTime = builder.sleepTime;
    }

    @Override
    public void doExecute(TestContext context) {
        if (log.isDebugEnabled()) {
            log.debug("Purging message endpoints ...");
        }
        for (Endpoint endpoint : this.endpoints) {
            this.purgeEndpoint(endpoint, context);
        }
        for (String endpointName : this.endpointNames) {
            this.purgeEndpoint(this.resolveEndpointName(endpointName), context);
        }
        log.info("Purged message endpoints");
    }

    private void purgeEndpoint(Endpoint endpoint, TestContext context) {
        Message message;
        if (log.isDebugEnabled()) {
            log.debug("Try to purge message endpoint " + endpoint.getName());
        }
        int messagesPurged = 0;
        Consumer messageConsumer = endpoint.createConsumer();
        do {
            try {
                String selector = MessageSelectorBuilder.build(this.messageSelector, this.messageSelectorMap, context);
                message = StringUtils.hasText((String)selector) && messageConsumer instanceof SelectiveConsumer ? (this.receiveTimeout >= 0L ? ((SelectiveConsumer)messageConsumer).receive(selector, context, this.receiveTimeout) : ((SelectiveConsumer)messageConsumer).receive(selector, context)) : (this.receiveTimeout >= 0L ? messageConsumer.receive(context, this.receiveTimeout) : messageConsumer.receive(context));
            }
            catch (ActionTimeoutException e) {
                if (!log.isDebugEnabled()) break;
                log.debug("Stop purging due to timeout - " + e.getMessage());
                break;
            }
            if (message == null) continue;
            log.debug("Removed message from endpoint " + endpoint.getName());
            ++messagesPurged;
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException e) {
                log.warn("Interrupted during wait", (Throwable)e);
            }
        } while (message != null);
        if (log.isDebugEnabled()) {
            log.debug("Purged " + messagesPurged + " messages from endpoint");
        }
    }

    protected Endpoint resolveEndpointName(String endpointName) {
        return (Endpoint)this.referenceResolver.resolve(endpointName, Endpoint.class);
    }

    public ReferenceResolver getReferenceResolver() {
        return this.referenceResolver;
    }

    public List<String> getEndpointNames() {
        return this.endpointNames;
    }

    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public Map<String, Object> getMessageSelectorMap() {
        return this.messageSelectorMap;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public static final class Builder
    extends AbstractTestActionBuilder<PurgeEndpointAction, Builder>
    implements ReferenceResolverAware {
        private final List<String> endpointNames = new ArrayList<String>();
        private final List<Endpoint> endpoints = new ArrayList<Endpoint>();
        private ReferenceResolver referenceResolver;
        private Map<String, Object> messageSelectorMap = new HashMap<String, Object>();
        private String messageSelector;
        private long receiveTimeout = 100L;
        private long sleepTime = 350L;

        public static Builder purge() {
            return new Builder();
        }

        public static Builder purgeEndpoints() {
            return new Builder();
        }

        public Builder selector(String messageSelector) {
            this.messageSelector = messageSelector;
            return this;
        }

        public Builder selector(Map<String, Object> messageSelector) {
            this.messageSelectorMap = messageSelector;
            return this;
        }

        public Builder endpointNames(List<String> endpointNames) {
            this.endpointNames.addAll(endpointNames);
            return this;
        }

        public Builder endpointNames(String ... endpointNames) {
            return this.endpointNames(Arrays.asList(endpointNames));
        }

        public Builder endpoint(String name) {
            this.endpointNames.add(name);
            return this;
        }

        public Builder endpoints(List<Endpoint> endpoints) {
            this.endpoints.addAll(endpoints);
            return this;
        }

        public Builder endpoints(Endpoint ... endpoints) {
            return this.endpoints(Arrays.asList(endpoints));
        }

        public Builder endpoint(Endpoint endpoint) {
            this.endpoints.add(endpoint);
            return this;
        }

        public Builder timeout(long receiveTimeout) {
            this.receiveTimeout = receiveTimeout;
            return this;
        }

        public Builder sleep(long millis) {
            this.sleepTime = millis;
            return this;
        }

        public Builder withReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
            return this;
        }

        public Builder referenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
            return this;
        }

        public void setReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
        }

        public PurgeEndpointAction build() {
            return new PurgeEndpointAction(this);
        }
    }
}

