/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.annotations;

import com.consol.citrus.Citrus;
import com.consol.citrus.CitrusContext;
import com.consol.citrus.GherkinTestActionRunner;
import com.consol.citrus.TestActionRunner;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.annotations.CitrusConfiguration;
import com.consol.citrus.annotations.CitrusEndpointAnnotations;
import com.consol.citrus.annotations.CitrusFramework;
import com.consol.citrus.annotations.CitrusResource;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.spi.BindToRegistry;
import com.consol.citrus.spi.ReferenceRegistry;
import com.consol.citrus.validation.MessageValidator;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public abstract class CitrusAnnotations {
    private static final Logger LOG = LoggerFactory.getLogger(CitrusAnnotations.class);

    private CitrusAnnotations() {
    }

    public static void injectAll(Object target) {
        CitrusAnnotations.injectAll(target, Citrus.newInstance());
    }

    public static void injectAll(Object target, Citrus citrusFramework) {
        CitrusAnnotations.injectAll(target, citrusFramework, citrusFramework.getCitrusContext().createTestContext());
    }

    public static void injectAll(Object target, Citrus citrusFramework, TestContext context) {
        CitrusAnnotations.injectCitrusFramework(target, citrusFramework);
        CitrusContext citrusContext = citrusFramework.getCitrusContext();
        CitrusAnnotations.injectCitrusContext(target, citrusContext);
        CitrusAnnotations.parseConfiguration(target, citrusContext);
        CitrusAnnotations.injectEndpoints(target, context);
        CitrusAnnotations.injectTestContext(target, context);
    }

    public static void injectEndpoints(Object target, TestContext context) {
        CitrusEndpointAnnotations.injectEndpoints((Object)target, (TestContext)context);
    }

    public static void injectCitrusFramework(final Object testCase, final Citrus citrusFramework) {
        ReflectionUtils.doWithFields(testCase.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                LOG.trace(String.format("Injecting Citrus framework instance on test class field '%s'", field.getName()));
                ReflectionUtils.setField((Field)field, (Object)testCase, (Object)citrusFramework);
            }
        }, (ReflectionUtils.FieldFilter)new ReflectionUtils.FieldFilter(){

            public boolean matches(Field field) {
                if (field.isAnnotationPresent(CitrusFramework.class) && Citrus.class.isAssignableFrom(field.getType())) {
                    if (!field.isAccessible()) {
                        ReflectionUtils.makeAccessible((Field)field);
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public static void injectCitrusContext(Object target, CitrusContext context) {
        ReflectionUtils.doWithFields(target.getClass(), field -> {
            LOG.trace(String.format("Injecting Citrus context instance on test class field '%s'", field.getName()));
            ReflectionUtils.setField((Field)field, (Object)target, (Object)context);
        }, field -> {
            if (field.isAnnotationPresent(CitrusResource.class) && CitrusContext.class.isAssignableFrom(field.getType())) {
                if (!field.isAccessible()) {
                    ReflectionUtils.makeAccessible((Field)field);
                }
                return true;
            }
            return false;
        });
    }

    public static void injectTestContext(Object target, TestContext context) {
        ReflectionUtils.doWithFields(target.getClass(), field -> {
            Class<?> type = field.getType();
            if (!TestContext.class.isAssignableFrom(type)) {
                throw new CitrusRuntimeException("Not able to provide a Citrus resource injection for type " + type);
            }
            LOG.trace(String.format("Injecting test context instance on test class field '%s'", field.getName()));
            ReflectionUtils.setField((Field)field, (Object)target, (Object)context);
        }, field -> {
            if (field.isAnnotationPresent(CitrusResource.class) && TestContext.class.isAssignableFrom(field.getType())) {
                if (!field.isAccessible()) {
                    ReflectionUtils.makeAccessible((Field)field);
                }
                return true;
            }
            return false;
        });
    }

    public static void injectTestRunner(Object target, TestCaseRunner runner) {
        ReflectionUtils.doWithFields(target.getClass(), field -> {
            Class<?> type = field.getType();
            if (!TestCaseRunner.class.isAssignableFrom(type)) {
                throw new CitrusRuntimeException("Not able to provide a Citrus resource injection for type " + type);
            }
            LOG.trace(String.format("Injecting test runner instance on test class field '%s'", field.getName()));
            ReflectionUtils.setField((Field)field, (Object)target, (Object)runner);
        }, field -> {
            if (field.isAnnotationPresent(CitrusResource.class) && TestCaseRunner.class.isAssignableFrom(field.getType())) {
                if (!field.isAccessible()) {
                    ReflectionUtils.makeAccessible((Field)field);
                }
                return true;
            }
            return false;
        });
        CitrusAnnotations.injectTestActionRunner(target, (TestActionRunner)runner);
        CitrusAnnotations.injectGherkinTestActionRunner(target, (GherkinTestActionRunner)runner);
    }

    private static void injectTestActionRunner(Object target, TestActionRunner runner) {
        ReflectionUtils.doWithFields(target.getClass(), field -> {
            Class<?> type = field.getType();
            if (!TestActionRunner.class.isAssignableFrom(type)) {
                throw new CitrusRuntimeException("Not able to provide a Citrus resource injection for type " + type);
            }
            LOG.trace(String.format("Injecting test action runner instance on test class field '%s'", field.getName()));
            ReflectionUtils.setField((Field)field, (Object)target, (Object)runner);
        }, field -> {
            if (field.isAnnotationPresent(CitrusResource.class) && TestActionRunner.class.isAssignableFrom(field.getType())) {
                if (!field.isAccessible()) {
                    ReflectionUtils.makeAccessible((Field)field);
                }
                return true;
            }
            return false;
        });
    }

    private static void injectGherkinTestActionRunner(Object target, GherkinTestActionRunner runner) {
        ReflectionUtils.doWithFields(target.getClass(), field -> {
            Class<?> type = field.getType();
            if (!GherkinTestActionRunner.class.isAssignableFrom(type)) {
                throw new CitrusRuntimeException("Not able to provide a Citrus resource injection for type " + type);
            }
            LOG.trace(String.format("Injecting test action runner instance on test class field '%s'", field.getName()));
            ReflectionUtils.setField((Field)field, (Object)target, (Object)runner);
        }, field -> {
            if (field.isAnnotationPresent(CitrusResource.class) && GherkinTestActionRunner.class.isAssignableFrom(field.getType())) {
                if (!field.isAccessible()) {
                    ReflectionUtils.makeAccessible((Field)field);
                }
                return true;
            }
            return false;
        });
    }

    public static void parseConfiguration(Class<?> configClass, CitrusContext citrusContext) {
        try {
            CitrusAnnotations.parseConfiguration(configClass.getConstructor(new Class[0]).newInstance(new Object[0]), citrusContext);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CitrusRuntimeException("Missing or non-accessible default constructor on custom configuration class", (Throwable)e);
        }
    }

    public static void parseConfiguration(Object configuration, CitrusContext citrusContext) {
        Class<?> configClass = configuration.getClass();
        if (configClass.isAnnotationPresent(CitrusConfiguration.class)) {
            for (Class type : configClass.getAnnotation(CitrusConfiguration.class).classes()) {
                CitrusAnnotations.parseConfiguration(type, citrusContext);
            }
        }
        Arrays.stream(configClass.getDeclaredMethods()).filter(m -> m.getAnnotation(BindToRegistry.class) != null).forEach(m -> {
            try {
                String name = ReferenceRegistry.getName((BindToRegistry)m.getAnnotation(BindToRegistry.class), (String)m.getName());
                Object component = m.invoke(configuration, new Object[0]);
                citrusContext.getReferenceResolver().bind(name, component);
                if (component instanceof MessageValidator) {
                    citrusContext.getMessageValidatorRegistry().addMessageValidator(name, (MessageValidator)component);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new CitrusRuntimeException("Failed to invoke configuration method", (Throwable)e);
            }
        });
        Arrays.stream(configClass.getDeclaredFields()).filter(f -> f.getAnnotation(BindToRegistry.class) != null).peek(ReflectionUtils::makeAccessible).forEach(f -> {
            try {
                String name = ReferenceRegistry.getName((BindToRegistry)f.getAnnotation(BindToRegistry.class), (String)f.getName());
                Object component = f.get(configuration);
                citrusContext.getReferenceResolver().bind(name, component);
                if (component instanceof MessageValidator) {
                    citrusContext.getMessageValidatorRegistry().addMessageValidator(name, (MessageValidator)component);
                }
            }
            catch (IllegalAccessException e) {
                throw new CitrusRuntimeException("Failed to access configuration field", (Throwable)e);
            }
        });
    }
}

