/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.container;

import com.consol.citrus.AbstractTestBoundaryContainerBuilder;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.container.AbstractTestBoundaryActionContainer;
import com.consol.citrus.container.BeforeTest;
import com.consol.citrus.context.TestContext;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SequenceBeforeTest
extends AbstractTestBoundaryActionContainer
implements BeforeTest {
    private static final Logger LOG = LoggerFactory.getLogger(SequenceBeforeTest.class);

    @Override
    public void doExecute(TestContext context) {
        if (CollectionUtils.isEmpty((Collection)this.actions)) {
            return;
        }
        LOG.info("Entering before test block");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing " + this.actions.size() + " actions before test");
            LOG.debug("");
        }
        for (TestActionBuilder actionBuilder : this.actions) {
            TestAction action = actionBuilder.build();
            action.execute(context);
        }
    }

    public static class Builder
    extends AbstractTestBoundaryContainerBuilder<SequenceBeforeTest, Builder> {
        public static Builder beforeTest() {
            return new Builder();
        }

        @Override
        public SequenceBeforeTest doBuild() {
            return new SequenceBeforeTest();
        }
    }
}

