/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.context;

import com.consol.citrus.container.AfterTest;
import com.consol.citrus.container.BeforeTest;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.DefaultEndpointFactory;
import com.consol.citrus.endpoint.EndpointFactory;
import com.consol.citrus.functions.FunctionRegistry;
import com.consol.citrus.log.DefaultLogModifier;
import com.consol.citrus.log.LogModifier;
import com.consol.citrus.message.MessageProcessors;
import com.consol.citrus.report.MessageListeners;
import com.consol.citrus.report.TestActionListeners;
import com.consol.citrus.report.TestListeners;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import com.consol.citrus.spi.SimpleReferenceResolver;
import com.consol.citrus.util.TypeConverter;
import com.consol.citrus.validation.MessageValidatorRegistry;
import com.consol.citrus.validation.matcher.ValidationMatcherRegistry;
import com.consol.citrus.variable.GlobalVariables;
import com.consol.citrus.variable.SegmentVariableExtractorRegistry;
import com.consol.citrus.xml.namespace.NamespaceContextBuilder;
import java.util.ArrayList;
import java.util.List;

public class TestContextFactory
implements ReferenceResolverAware {
    private FunctionRegistry functionRegistry;
    private ValidationMatcherRegistry validationMatcherRegistry;
    private GlobalVariables globalVariables = new GlobalVariables();
    private MessageValidatorRegistry messageValidatorRegistry;
    private TestListeners testListeners;
    private TestActionListeners testActionListeners;
    private List<BeforeTest> beforeTest = new ArrayList<BeforeTest>();
    private List<AfterTest> afterTest = new ArrayList<AfterTest>();
    private MessageListeners messageListeners;
    private EndpointFactory endpointFactory;
    private ReferenceResolver referenceResolver;
    private MessageProcessors messageProcessors;
    private NamespaceContextBuilder namespaceContextBuilder;
    private TypeConverter typeConverter;
    private LogModifier logModifier;
    private SegmentVariableExtractorRegistry segmentVariableExtractorRegistry;

    public static TestContextFactory newInstance() {
        TestContextFactory factory = new TestContextFactory();
        factory.setFunctionRegistry(new FunctionRegistry());
        factory.setValidationMatcherRegistry(new ValidationMatcherRegistry());
        factory.setGlobalVariables(new GlobalVariables());
        factory.setMessageValidatorRegistry(new MessageValidatorRegistry());
        factory.setTestListeners(new TestListeners());
        factory.setTestActionListeners(new TestActionListeners());
        factory.setMessageListeners(new MessageListeners());
        factory.setMessageProcessors(new MessageProcessors());
        factory.setEndpointFactory((EndpointFactory)new DefaultEndpointFactory());
        factory.setReferenceResolver((ReferenceResolver)new SimpleReferenceResolver());
        factory.setNamespaceContextBuilder(new NamespaceContextBuilder());
        factory.setTypeConverter(TypeConverter.lookupDefault());
        factory.setLogModifier((LogModifier)new DefaultLogModifier());
        factory.setSegmentVariableExtractorRegistry(new SegmentVariableExtractorRegistry());
        return factory;
    }

    public TestContext getObject() {
        TestContext context = new TestContext();
        context.setFunctionRegistry(this.functionRegistry);
        context.setValidationMatcherRegistry(this.validationMatcherRegistry);
        context.setGlobalVariables(this.globalVariables);
        context.setMessageValidatorRegistry(this.messageValidatorRegistry);
        context.setTestListeners(this.testListeners);
        context.setTestActionListeners(this.testActionListeners);
        context.setBeforeTest(this.beforeTest);
        context.setAfterTest(this.afterTest);
        context.setMessageListeners(this.messageListeners);
        context.setMessageProcessors(this.messageProcessors);
        context.setEndpointFactory(this.endpointFactory);
        context.setReferenceResolver(this.referenceResolver);
        context.setSegmentVariableExtractorRegistry(this.segmentVariableExtractorRegistry);
        if (this.namespaceContextBuilder != null) {
            context.setNamespaceContextBuilder(this.namespaceContextBuilder);
        }
        if (this.typeConverter != null) {
            context.setTypeConverter(this.typeConverter);
        }
        if (this.logModifier != null) {
            context.setLogModifier(this.logModifier);
        }
        return context;
    }

    public void setFunctionRegistry(FunctionRegistry functionRegistry) {
        this.functionRegistry = functionRegistry;
    }

    public FunctionRegistry getFunctionRegistry() {
        return this.functionRegistry;
    }

    public void setValidationMatcherRegistry(ValidationMatcherRegistry validationMatcherRegistry) {
        this.validationMatcherRegistry = validationMatcherRegistry;
    }

    public ValidationMatcherRegistry getValidationMatcherRegistry() {
        return this.validationMatcherRegistry;
    }

    public void setGlobalVariables(GlobalVariables globalVariables) {
        this.globalVariables = globalVariables;
    }

    public GlobalVariables getGlobalVariables() {
        return this.globalVariables;
    }

    public EndpointFactory getEndpointFactory() {
        return this.endpointFactory;
    }

    public void setEndpointFactory(EndpointFactory endpointFactory) {
        this.endpointFactory = endpointFactory;
    }

    public ReferenceResolver getReferenceResolver() {
        return this.referenceResolver;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    public void setNamespaceContextBuilder(NamespaceContextBuilder namespaceContextBuilder) {
        this.namespaceContextBuilder = namespaceContextBuilder;
    }

    public NamespaceContextBuilder getNamespaceContextBuilder() {
        return this.namespaceContextBuilder;
    }

    public void setTestListeners(TestListeners testListeners) {
        this.testListeners = testListeners;
    }

    public TestListeners getTestListeners() {
        return this.testListeners;
    }

    public TestActionListeners getTestActionListeners() {
        return this.testActionListeners;
    }

    public void setTestActionListeners(TestActionListeners testActionListeners) {
        this.testActionListeners = testActionListeners;
    }

    public List<BeforeTest> getBeforeTest() {
        return this.beforeTest;
    }

    public void setBeforeTest(List<BeforeTest> beforeTest) {
        this.beforeTest = beforeTest;
    }

    public List<AfterTest> getAfterTest() {
        return this.afterTest;
    }

    public void setAfterTest(List<AfterTest> afterTest) {
        this.afterTest = afterTest;
    }

    public void setMessageValidatorRegistry(MessageValidatorRegistry messageValidatorRegistry) {
        this.messageValidatorRegistry = messageValidatorRegistry;
    }

    public MessageValidatorRegistry getMessageValidatorRegistry() {
        return this.messageValidatorRegistry;
    }

    public void setMessageListeners(MessageListeners messageListeners) {
        this.messageListeners = messageListeners;
    }

    public MessageListeners getMessageListeners() {
        return this.messageListeners;
    }

    public void setMessageProcessors(MessageProcessors messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    public MessageProcessors getMessageProcessors() {
        return this.messageProcessors;
    }

    public TypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    public void setTypeConverter(TypeConverter typeConverter) {
        this.typeConverter = typeConverter;
    }

    public LogModifier getLogModifier() {
        return this.logModifier;
    }

    public void setLogModifier(LogModifier logModifier) {
        this.logModifier = logModifier;
    }

    public SegmentVariableExtractorRegistry getSegmentVariableExtractorRegistry() {
        return this.segmentVariableExtractorRegistry;
    }

    public void setSegmentVariableExtractorRegistry(SegmentVariableExtractorRegistry segmentVariableExtractorRegistry) {
        this.segmentVariableExtractorRegistry = segmentVariableExtractorRegistry;
    }
}

