/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.endpoint;

import com.consol.citrus.TestActor;
import com.consol.citrus.common.InitializingPhase;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.endpoint.EndpointBuilder;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;

public abstract class AbstractEndpointBuilder<T extends Endpoint>
implements EndpointBuilder<T> {
    public AbstractEndpointBuilder<T> name(String endpointName) {
        this.getEndpoint().setName(endpointName);
        return this;
    }

    public AbstractEndpointBuilder<T> actor(TestActor actor) {
        this.getEndpoint().setActor(actor);
        return this;
    }

    public AbstractEndpointBuilder<T> initialize() {
        if (this.getEndpoint() instanceof InitializingPhase) {
            try {
                ((InitializingPhase)this.getEndpoint()).initialize();
            }
            catch (Exception e) {
                throw new CitrusRuntimeException("Failed to initialize server", (Throwable)e);
            }
        }
        return this;
    }

    public AbstractEndpointBuilder<T> referenceResolver(ReferenceResolver referenceResolver) {
        if (this.getEndpoint() instanceof ReferenceResolverAware) {
            ((ReferenceResolverAware)this.getEndpoint()).setReferenceResolver(referenceResolver);
        }
        return this;
    }

    public T build() {
        return this.getEndpoint();
    }

    public boolean supports(Class<?> endpointType) {
        return this.getEndpoint().getClass().equals(endpointType);
    }

    protected abstract T getEndpoint();
}

