/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.endpoint.direct;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.direct.DirectEndpointConfiguration;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageQueue;
import com.consol.citrus.messaging.Producer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DirectProducer
implements Producer {
    private static final Logger log = LoggerFactory.getLogger(DirectProducer.class);
    private final String name;
    private final DirectEndpointConfiguration endpointConfiguration;

    public DirectProducer(String name, DirectEndpointConfiguration endpointConfiguration) {
        this.name = name;
        this.endpointConfiguration = endpointConfiguration;
    }

    public void send(Message message, TestContext context) {
        String destinationQueueName = this.getDestinationQueueName();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Sending message to queue: '%s'", destinationQueueName));
        }
        if (log.isDebugEnabled()) {
            log.debug("Message to send is:" + System.getProperty("line.separator") + message.toString());
        }
        try {
            this.getDestinationQueue(context).send(message);
        }
        catch (Exception e) {
            throw new CitrusRuntimeException(String.format("Failed to send message to queue: '%s'", destinationQueueName), (Throwable)e);
        }
        log.info(String.format("Message was sent to queue: '%s'", destinationQueueName));
    }

    protected MessageQueue getDestinationQueue(TestContext context) {
        if (this.endpointConfiguration.getQueue() != null) {
            return this.endpointConfiguration.getQueue();
        }
        if (StringUtils.hasText((String)this.endpointConfiguration.getQueueName())) {
            return this.resolveQueueName(this.endpointConfiguration.getQueueName(), context);
        }
        throw new CitrusRuntimeException("Neither queue name nor queue object is set - please specify destination queue");
    }

    protected String getDestinationQueueName() {
        if (this.endpointConfiguration.getQueue() != null) {
            return this.endpointConfiguration.getQueue().toString();
        }
        if (StringUtils.hasText((String)this.endpointConfiguration.getQueueName())) {
            return this.endpointConfiguration.getQueueName();
        }
        throw new CitrusRuntimeException("Neither queue name nor queue object is set - please specify destination queue");
    }

    protected MessageQueue resolveQueueName(String queueName, TestContext context) {
        if (context.getReferenceResolver() != null) {
            return (MessageQueue)context.getReferenceResolver().resolve(queueName, MessageQueue.class);
        }
        throw new CitrusRuntimeException("Unable to resolve message queue - missing proper reference resolver in context");
    }

    public String getName() {
        return this.name;
    }
}

