/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.functions;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.functions.core.ChangeDateFunction;
import com.consol.citrus.functions.core.CurrentDateFunction;
import com.consol.citrus.functions.core.DecodeBase64Function;
import com.consol.citrus.functions.core.DigestAuthHeaderFunction;
import com.consol.citrus.functions.core.EncodeBase64Function;
import com.consol.citrus.functions.core.RandomNumberFunction;
import com.consol.citrus.functions.core.RandomStringFunction;
import com.consol.citrus.functions.core.RandomUUIDFunction;
import com.consol.citrus.functions.core.ReadFileResourceFunction;
import com.consol.citrus.functions.core.UnixTimestampFunction;
import com.consol.citrus.functions.core.UrlDecodeFunction;
import com.consol.citrus.functions.core.UrlEncodeFunction;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;

public final class Functions {
    private Functions() {
    }

    public static String currentDate(TestContext context) {
        return new CurrentDateFunction().execute(Collections.emptyList(), context);
    }

    public static String currentDate(String dateFormat, TestContext context) {
        return new CurrentDateFunction().execute(Collections.singletonList(dateFormat), context);
    }

    public static String changeDate(String date, String dateOffset, String dateFormat, TestContext context) {
        return new ChangeDateFunction().execute(Arrays.asList(date, dateOffset, dateFormat), context);
    }

    public static String changeDate(String date, String dateOffset, TestContext context) {
        return new ChangeDateFunction().execute(Arrays.asList(date, dateOffset), context);
    }

    public static String encodeBase64(String content, TestContext context) {
        return new EncodeBase64Function().execute(Collections.singletonList(content), context);
    }

    public static String encodeBase64(String content, Charset charset, TestContext context) {
        return new EncodeBase64Function().execute(Arrays.asList(content, charset.displayName()), context);
    }

    public static String decodeBase64(String content, TestContext context) {
        return new DecodeBase64Function().execute(Collections.singletonList(content), context);
    }

    public static String decodeBase64(String content, Charset charset, TestContext context) {
        return new DecodeBase64Function().execute(Arrays.asList(content, charset.displayName()), context);
    }

    public static String urlEncode(String content, TestContext context) {
        return new UrlEncodeFunction().execute(Collections.singletonList(content), context);
    }

    public static String urlEncode(String content, Charset charset, TestContext context) {
        return new UrlEncodeFunction().execute(Arrays.asList(content, charset.displayName()), context);
    }

    public static String urlDecode(String content, TestContext context) {
        return new UrlDecodeFunction().execute(Collections.singletonList(content), context);
    }

    public static String urlDecode(String content, Charset charset, TestContext context) {
        return new UrlDecodeFunction().execute(Arrays.asList(content, charset.displayName()), context);
    }

    public static String digestAuthHeader(String username, String password, String realm, String noncekey, String method, String uri, String opaque, String algorithm, TestContext context) {
        return new DigestAuthHeaderFunction().execute(Arrays.asList(username, password, realm, noncekey, method, uri, opaque, algorithm), context);
    }

    public static String randomUUID(TestContext context) {
        return new RandomUUIDFunction().execute(Collections.emptyList(), context);
    }

    public static String randomNumber(Long length, TestContext context) {
        return new RandomNumberFunction().execute(Collections.singletonList(String.valueOf(length)), context);
    }

    public static String randomNumber(Long length, boolean padding, TestContext context) {
        return new RandomNumberFunction().execute(Arrays.asList(String.valueOf(length), String.valueOf(padding)), context);
    }

    public static String randomString(Long numberOfLetters, TestContext context) {
        return new RandomStringFunction().execute(Collections.singletonList(String.valueOf(numberOfLetters)), context);
    }

    public static String randomString(Long numberOfLetters, boolean useNumbers, TestContext context) {
        return Functions.randomString(numberOfLetters, "MIXED", useNumbers, context);
    }

    public static String randomString(Long numberOfLetters, String notationMethod, boolean useNumbers, TestContext context) {
        return new RandomStringFunction().execute(Arrays.asList(String.valueOf(numberOfLetters), notationMethod, String.valueOf(useNumbers)), context);
    }

    public static String randomString(Long numberOfLetters, String notationMethod, TestContext context) {
        return new RandomStringFunction().execute(Arrays.asList(String.valueOf(numberOfLetters), String.valueOf(notationMethod)), context);
    }

    public static String readFile(String filePath, TestContext context) {
        return new ReadFileResourceFunction().execute(Collections.singletonList(filePath), context);
    }

    public static String unixTimestamp(TestContext context) {
        return new UnixTimestampFunction().execute(Collections.emptyList(), context);
    }
}

