/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.functions.core;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.InvalidFunctionUsageException;
import com.consol.citrus.functions.core.AbstractDateFunction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ChangeDateFunction
extends AbstractDateFunction {
    private static Logger log = LoggerFactory.getLogger(ChangeDateFunction.class);

    public String execute(List<String> parameterList, TestContext context) {
        if (CollectionUtils.isEmpty(parameterList)) {
            throw new InvalidFunctionUsageException("Function parameters must not be empty");
        }
        Calendar calendar = Calendar.getInstance();
        String result = "";
        SimpleDateFormat dateFormat = parameterList.size() > 2 ? new SimpleDateFormat(parameterList.get(2)) : this.getDefaultDateFormat();
        try {
            calendar.setTime(dateFormat.parse(parameterList.get(0)));
        }
        catch (ParseException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
        if (parameterList.size() > 1) {
            this.applyDateOffset(calendar, parameterList.get(1));
        }
        try {
            result = dateFormat.format(calendar.getTime());
        }
        catch (RuntimeException e) {
            log.error("Error while formatting dateParameter value ", (Throwable)e);
            throw new CitrusRuntimeException((Throwable)e);
        }
        return result;
    }
}

