/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.message;

import com.consol.citrus.context.TestContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class MessageSelectorBuilder {
    private String selectorString = "";

    public MessageSelectorBuilder(String selectorString) {
        this.selectorString = selectorString;
    }

    public static String build(String messageSelector, Map<String, Object> messageSelectorMap, TestContext context) {
        if (StringUtils.hasText((String)messageSelector)) {
            return context.replaceDynamicContentInString(messageSelector);
        }
        if (!CollectionUtils.isEmpty(messageSelectorMap)) {
            return MessageSelectorBuilder.fromKeyValueMap(context.resolveDynamicValuesInMap(messageSelectorMap)).build();
        }
        return "";
    }

    public static MessageSelectorBuilder withString(String selectorString) {
        return new MessageSelectorBuilder(selectorString);
    }

    public static MessageSelectorBuilder fromKeyValueMap(Map<String, Object> valueMap) {
        String value;
        String key;
        Map.Entry<String, Object> entry;
        StringBuffer buf = new StringBuffer();
        Iterator<Map.Entry<String, Object>> iter = valueMap.entrySet().iterator();
        if (iter.hasNext()) {
            entry = iter.next();
            key = entry.getKey();
            value = entry.getValue().toString();
            buf.append(key + " = '" + value + "'");
        }
        while (iter.hasNext()) {
            entry = iter.next();
            key = entry.getKey();
            value = entry.getValue().toString();
            buf.append(" AND " + key + " = '" + value + "'");
        }
        return new MessageSelectorBuilder(buf.toString());
    }

    public Map<String, String> toKeyValueMap() {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        if (this.selectorString.contains(" AND")) {
            String[] chunks;
            for (String chunk : chunks = this.selectorString.split(" AND")) {
                String[] tokens = this.escapeEqualsFromXpathNodeTest(chunk).split("=");
                valueMap.put(this.unescapeEqualsFromXpathNodeTest(tokens[0].trim()), tokens[1].trim().substring(1, tokens[1].trim().length() - 1));
            }
        } else {
            String[] tokens = this.escapeEqualsFromXpathNodeTest(this.selectorString).split("=");
            valueMap.put(this.unescapeEqualsFromXpathNodeTest(tokens[0].trim()), tokens[1].trim().substring(1, tokens[1].trim().length() - 1));
        }
        return valueMap;
    }

    private String escapeEqualsFromXpathNodeTest(String selectorExpression) {
        String nodeTestStart = "[";
        String nodeTestEnd = "]";
        if (!selectorExpression.contains(nodeTestStart) || !selectorExpression.contains(nodeTestEnd)) {
            return selectorExpression;
        }
        StringBuilder selectorBuilder = new StringBuilder();
        int nodeTestStartIndex = selectorExpression.indexOf(nodeTestStart);
        int nodeTestEndIndex = selectorExpression.indexOf(nodeTestEnd);
        boolean escape = false;
        for (int i = 0; i < selectorExpression.length(); ++i) {
            if (i == nodeTestStartIndex) {
                escape = true;
            }
            if (escape && selectorExpression.charAt(i) == '=') {
                selectorBuilder.append("@equals@");
            } else {
                selectorBuilder.append(selectorExpression.charAt(i));
            }
            if (i != nodeTestEndIndex) continue;
            nodeTestStartIndex = selectorExpression.indexOf(nodeTestStart);
            nodeTestEndIndex = selectorExpression.indexOf(nodeTestEnd);
            escape = false;
        }
        return selectorBuilder.toString();
    }

    private String unescapeEqualsFromXpathNodeTest(String expression) {
        return expression.replaceAll("@equals@", "=");
    }

    public String build() {
        return this.selectorString;
    }
}

