/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.message.selector;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageSelector;
import com.consol.citrus.message.selector.AbstractMessageSelector;
import org.springframework.util.Assert;

public class PayloadMatchingMessageSelector
extends AbstractMessageSelector {
    public static final String SELECTOR_ID = "payload";

    public PayloadMatchingMessageSelector(String selectKey, String matchingValue, TestContext context) {
        super(selectKey, matchingValue, context);
        Assert.isTrue((boolean)selectKey.equals(SELECTOR_ID), (String)String.format("Invalid usage of payload matching message selector - usage restricted to key '%s' but was '%s'", SELECTOR_ID, selectKey));
    }

    public boolean accept(Message message) {
        return this.evaluate(this.getPayloadAsString(message));
    }

    public static class Factory
    implements MessageSelector.MessageSelectorFactory {
        public boolean supports(String key) {
            return key.equals(PayloadMatchingMessageSelector.SELECTOR_ID);
        }

        public PayloadMatchingMessageSelector create(String key, String value, TestContext context) {
            return new PayloadMatchingMessageSelector(key, value, context);
        }
    }
}

