/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.util;

import com.consol.citrus.message.Message;
import com.consol.citrus.util.IsJsonPredicate;
import com.consol.citrus.util.IsXmlPredicate;
import java.util.Optional;

public class MessageUtils {
    private MessageUtils() {
    }

    public static boolean hasXmlPayload(Message message) {
        if (!(message.getPayload() instanceof String)) {
            return false;
        }
        return Optional.ofNullable((String)message.getPayload(String.class)).map(String::trim).map(payload -> IsXmlPredicate.getInstance().test(payload)).orElse(true);
    }

    public static boolean hasJsonPayload(Message message) {
        if (!(message.getPayload() instanceof String)) {
            return false;
        }
        return Optional.ofNullable((String)message.getPayload(String.class)).map(String::trim).map(payload -> IsJsonPredicate.getInstance().test(payload)).orElse(true);
    }
}

