/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.util;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.io.IOException;
import java.util.Properties;
import org.springframework.core.io.Resource;

public final class PropertyUtils {
    private static final char PROPERTY_MARKER = '@';

    private PropertyUtils() {
    }

    public static String replacePropertiesInString(String line, Resource propertyResource) {
        Properties properties = new Properties();
        try {
            properties.load(propertyResource.getInputStream());
        }
        catch (IOException e) {
            return line;
        }
        return PropertyUtils.replacePropertiesInString(line, properties);
    }

    public static String replacePropertiesInString(String line, Properties properties) {
        int searchIndex;
        StringBuffer newStr = new StringBuffer();
        boolean isVarComplete = false;
        StringBuffer propertyName = new StringBuffer();
        int startIndex = 0;
        while ((searchIndex = line.indexOf(64, startIndex)) != -1) {
            int curIndex;
            if (searchIndex != 0 && line.charAt(searchIndex - 1) == '\\') {
                newStr.append(line.substring(startIndex, searchIndex - 1));
                newStr.append('@');
                startIndex = searchIndex + 1;
                continue;
            }
            isVarComplete = false;
            for (curIndex = searchIndex + 1; curIndex < line.length() && !isVarComplete; ++curIndex) {
                if (line.charAt(curIndex) == '@' || curIndex + 1 == line.length()) {
                    isVarComplete = true;
                }
                if (isVarComplete) continue;
                propertyName.append(line.charAt(curIndex));
            }
            if (!properties.containsKey(propertyName.toString())) {
                throw new CitrusRuntimeException("No such property '@" + propertyName.toString() + "@'");
            }
            newStr.append(line.substring(startIndex, searchIndex));
            newStr.append(properties.getProperty(propertyName.toString(), ""));
            startIndex = curIndex;
            propertyName = new StringBuffer();
            isVarComplete = false;
        }
        newStr.append(line.substring(startIndex));
        return newStr.toString();
    }
}

