/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.json;

import com.consol.citrus.builder.WithExpressions;
import com.consol.citrus.validation.context.DefaultValidationContext;
import com.consol.citrus.validation.context.ValidationContext;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.StringUtils;

public class JsonPathMessageValidationContext
extends DefaultValidationContext {
    private final Map<String, Object> jsonPathExpressions;

    public JsonPathMessageValidationContext(Builder builder) {
        this.jsonPathExpressions = builder.expressions;
    }

    public JsonPathMessageValidationContext() {
        this(new Builder());
    }

    public Map<String, Object> getJsonPathExpressions() {
        return this.jsonPathExpressions;
    }

    public static boolean isJsonPathExpression(String pathExpression) {
        return StringUtils.hasText((String)pathExpression) && pathExpression.startsWith("$");
    }

    public static final class Builder
    implements ValidationContext.Builder<JsonPathMessageValidationContext, Builder>,
    WithExpressions<Builder> {
        private final Map<String, Object> expressions = new HashMap<String, Object>();

        public static Builder jsonPath() {
            return new Builder();
        }

        public Builder expressions(Map<String, Object> expressions) {
            this.expressions.putAll(expressions);
            return this;
        }

        public Builder expression(String expression, Object value) {
            this.expressions.put(expression, value);
            return this;
        }

        public JsonPathMessageValidationContext build() {
            return new JsonPathMessageValidationContext(this);
        }
    }
}

