/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.matcher;

import com.consol.citrus.validation.matcher.ValidationMatcher;
import com.consol.citrus.validation.matcher.ValidationMatcherLibrary;
import com.consol.citrus.validation.matcher.core.ContainsIgnoreCaseValidationMatcher;
import com.consol.citrus.validation.matcher.core.ContainsValidationMatcher;
import com.consol.citrus.validation.matcher.core.CreateVariableValidationMatcher;
import com.consol.citrus.validation.matcher.core.DatePatternValidationMatcher;
import com.consol.citrus.validation.matcher.core.DateRangeValidationMatcher;
import com.consol.citrus.validation.matcher.core.EmptyValidationMatcher;
import com.consol.citrus.validation.matcher.core.EndsWithValidationMatcher;
import com.consol.citrus.validation.matcher.core.EqualsIgnoreCaseValidationMatcher;
import com.consol.citrus.validation.matcher.core.GreaterThanValidationMatcher;
import com.consol.citrus.validation.matcher.core.IgnoreNewLineValidationMatcher;
import com.consol.citrus.validation.matcher.core.IgnoreValidationMatcher;
import com.consol.citrus.validation.matcher.core.IsNumberValidationMatcher;
import com.consol.citrus.validation.matcher.core.LowerThanValidationMatcher;
import com.consol.citrus.validation.matcher.core.MatchesValidationMatcher;
import com.consol.citrus.validation.matcher.core.NotEmptyValidationMatcher;
import com.consol.citrus.validation.matcher.core.NotNullValidationMatcher;
import com.consol.citrus.validation.matcher.core.NullValidationMatcher;
import com.consol.citrus.validation.matcher.core.StartsWithValidationMatcher;
import com.consol.citrus.validation.matcher.core.StringLengthValidationMatcher;
import com.consol.citrus.validation.matcher.core.TrimAllWhitespacesValidationMatcher;
import com.consol.citrus.validation.matcher.core.TrimValidationMatcher;
import com.consol.citrus.validation.matcher.core.WeekdayValidationMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultValidationMatcherLibrary
extends ValidationMatcherLibrary {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultValidationMatcherLibrary.class);

    public DefaultValidationMatcherLibrary() {
        this.setName("citrusValidationMatcherLibrary");
        this.getMembers().put("equalsIgnoreCase", new EqualsIgnoreCaseValidationMatcher());
        this.getMembers().put("ignoreNewLine", new IgnoreNewLineValidationMatcher());
        this.getMembers().put("trim", new TrimValidationMatcher());
        this.getMembers().put("trimAllWhitespaces", new TrimAllWhitespacesValidationMatcher());
        this.getMembers().put("contains", new ContainsValidationMatcher());
        this.getMembers().put("containsIgnoreCase", new ContainsIgnoreCaseValidationMatcher());
        this.getMembers().put("greaterThan", new GreaterThanValidationMatcher());
        this.getMembers().put("lowerThan", new LowerThanValidationMatcher());
        this.getMembers().put("startsWith", new StartsWithValidationMatcher());
        this.getMembers().put("endsWith", new EndsWithValidationMatcher());
        this.getMembers().put("isNumber", new IsNumberValidationMatcher());
        this.getMembers().put("matches", new MatchesValidationMatcher());
        this.getMembers().put("matchesDatePattern", new DatePatternValidationMatcher());
        this.getMembers().put("isWeekday", new WeekdayValidationMatcher());
        this.getMembers().put("variable", new CreateVariableValidationMatcher());
        this.getMembers().put("dateRange", new DateRangeValidationMatcher());
        this.getMembers().put("empty", new EmptyValidationMatcher());
        this.getMembers().put("notEmpty", new NotEmptyValidationMatcher());
        this.getMembers().put("null", new NullValidationMatcher());
        this.getMembers().put("notNull", new NotNullValidationMatcher());
        this.getMembers().put("ignore", new IgnoreValidationMatcher());
        this.getMembers().put("hasLength", new StringLengthValidationMatcher());
        this.lookupValidationMatchers();
    }

    private void lookupValidationMatchers() {
        ValidationMatcher.lookup().forEach((k, m) -> {
            this.getMembers().put(k, m);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Register message matcher '%s' as %s", k, m.getClass()));
            }
        });
    }
}

