/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.matcher.core;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.validation.matcher.ControlExpressionParser;
import com.consol.citrus.validation.matcher.ValidationMatcher;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeekdayValidationMatcher
implements ValidationMatcher,
ControlExpressionParser {
    private static final Logger LOG = LoggerFactory.getLogger(WeekdayValidationMatcher.class);

    public void validate(String fieldName, String value, List<String> controlParameters, TestContext context) throws ValidationException {
        SimpleDateFormat dateFormat;
        String weekday = controlParameters.get(0);
        String formatString = "dd.MM.yyyy";
        if (controlParameters.size() == 2) {
            formatString = controlParameters.get(1);
        }
        try {
            dateFormat = new SimpleDateFormat(formatString);
        }
        catch (PatternSyntaxException e) {
            throw new ValidationException(this.getClass().getSimpleName() + " failed for field '" + fieldName + "' . Found invalid date format", (Throwable)e);
        }
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(dateFormat.parse(value));
            if (cal.get(7) != Weekday.valueOf(weekday).getConstantValue()) {
                throw new ValidationException(this.getClass().getSimpleName() + " failed for field '" + fieldName + "'. Received invalid week day '" + value + "', expected date to be a '" + weekday + "'");
            }
            LOG.info("Weekday validation matcher successful - All values OK");
        }
        catch (ParseException e) {
            throw new ValidationException(this.getClass().getSimpleName() + " failed for field '" + fieldName + "'. Received invalid date format for value '" + value + "', expected date format is '" + formatString + "'", (Throwable)e);
        }
    }

    public List<String> extractControlValues(String controlExpression, Character delimiter) {
        ArrayList<String> parameters = new ArrayList<String>();
        if (controlExpression.contains("(")) {
            parameters.add(controlExpression.substring(0, controlExpression.indexOf("('")));
            parameters.add(controlExpression.substring(controlExpression.indexOf("('") + 2, controlExpression.length() - 2));
        } else {
            parameters.add(controlExpression);
        }
        return parameters;
    }

    private static enum Weekday {
        MONDAY(2),
        TUESDAY(3),
        WEDNESDAY(4),
        THURSDAY(5),
        FRIDAY(6),
        SATURDAY(7),
        SUNDAY(1);

        private int constantValue;

        private Weekday(int constant) {
            this.constantValue = constant;
        }

        public int getConstantValue() {
            return this.constantValue;
        }
    }
}

