/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.xml;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.xml.Marshaller;
import com.consol.citrus.xml.Unmarshaller;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Jaxb2Marshaller
implements Marshaller,
Unmarshaller {
    private static final Logger log = LoggerFactory.getLogger(Jaxb2Marshaller.class);
    private volatile JAXBContext jaxbContext;
    private final Schema schema;
    private final Class<?>[] classesToBeBound;
    private final String contextPath;
    private final Map<String, Object> marshallerProperties = new HashMap<String, Object>();

    public Jaxb2Marshaller() {
        this(new Class[0]);
    }

    public Jaxb2Marshaller(Class<?> ... classesToBeBound) {
        this.classesToBeBound = classesToBeBound;
        this.contextPath = null;
        this.schema = null;
    }

    public Jaxb2Marshaller(String ... contextPaths) {
        this.classesToBeBound = null;
        this.contextPath = StringUtils.arrayToDelimitedString((Object[])contextPaths, (String)":");
        this.schema = null;
    }

    public Jaxb2Marshaller(Resource schemaResource, Class<?> ... classesToBeBound) {
        this.classesToBeBound = classesToBeBound;
        this.contextPath = null;
        this.schema = this.loadSchema(schemaResource);
    }

    public Jaxb2Marshaller(Resource schemaResource, String ... contextPaths) {
        this.classesToBeBound = null;
        this.contextPath = StringUtils.arrayToDelimitedString((Object[])contextPaths, (String)":");
        this.schema = this.loadSchema(schemaResource);
    }

    public Jaxb2Marshaller(Resource[] schemaResources, Class<?> ... classesToBeBound) {
        this.classesToBeBound = classesToBeBound;
        this.contextPath = null;
        this.schema = this.loadSchema(schemaResources);
    }

    public Jaxb2Marshaller(Resource[] schemaResources, String ... contextPaths) {
        this.classesToBeBound = null;
        this.contextPath = StringUtils.arrayToDelimitedString((Object[])contextPaths, (String)":");
        this.schema = this.loadSchema(schemaResources);
    }

    public void marshal(Object graph, Result result) throws JAXBException {
        this.createMarshaller().marshal(graph, result);
    }

    public Object unmarshal(Source source) throws JAXBException {
        return this.createUnmarshaller().unmarshal(source);
    }

    private javax.xml.bind.Marshaller createMarshaller() throws JAXBException {
        javax.xml.bind.Marshaller marshaller = this.getOrCreateContext().createMarshaller();
        if (this.schema != null) {
            marshaller.setSchema(this.schema);
        }
        this.marshallerProperties.forEach((k, v) -> {
            try {
                marshaller.setProperty(k, v);
            }
            catch (PropertyException e) {
                log.warn(String.format("Unable to set marshaller property %s=%s", k, v));
            }
        });
        return marshaller;
    }

    private javax.xml.bind.Unmarshaller createUnmarshaller() throws JAXBException {
        javax.xml.bind.Unmarshaller unmarshaller = this.getOrCreateContext().createUnmarshaller();
        if (this.schema != null) {
            unmarshaller.setSchema(this.schema);
        }
        return unmarshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JAXBContext getOrCreateContext() throws JAXBException {
        if (this.jaxbContext == null) {
            Jaxb2Marshaller jaxb2Marshaller = this;
            synchronized (jaxb2Marshaller) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Creating JAXBContext with bound classes %s", Arrays.toString(this.classesToBeBound)));
                }
                this.jaxbContext = this.classesToBeBound != null ? JAXBContext.newInstance((Class[])this.classesToBeBound) : (this.contextPath != null ? JAXBContext.newInstance((String)this.contextPath) : JAXBContext.newInstance((Class[])new Class[0]));
            }
        }
        return this.jaxbContext;
    }

    public void setProperty(String key, Object value) {
        this.marshallerProperties.put(key, value);
    }

    private Schema loadSchema(Resource ... schemas) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Using marshaller validation schemas '%s'", StringUtils.arrayToCommaDelimitedString((Object[])schemas)));
        }
        try {
            ArrayList<SAXSource> schemaSources = new ArrayList<SAXSource>();
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            for (Resource resource : schemas) {
                Assert.isTrue((resource != null && resource.exists() ? 1 : 0) != 0, () -> "Resource does not exist: " + resource);
                InputSource inputSource = new InputSource(resource.getInputStream());
                inputSource.setSystemId(resource.getURI().toString());
                schemaSources.add(new SAXSource(xmlReader, inputSource));
            }
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            return schemaFactory.newSchema(schemaSources.toArray(new Source[0]));
        }
        catch (IOException | SAXException e) {
            throw new CitrusRuntimeException("Failed to load schemas for marshaller", (Throwable)e);
        }
    }
}

