/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.validation;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.http.model.Control;
import com.consol.citrus.http.model.FormData;
import com.consol.citrus.http.model.FormMarshaller;
import com.consol.citrus.http.model.ObjectFactory;
import com.consol.citrus.message.DefaultMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.validation.DefaultMessageValidator;
import com.consol.citrus.validation.context.ValidationContext;
import com.consol.citrus.validation.xml.DomXmlMessageValidator;
import com.consol.citrus.validation.xml.XmlMessageValidationContext;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.transform.Result;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.xml.transform.StringResult;

public class FormUrlEncodedMessageValidator
extends DefaultMessageValidator {
    public static final String MESSAGE_TYPE = "x-www-form-urlencoded";
    private FormMarshaller formMarshaller = new FormMarshaller();
    private DomXmlMessageValidator xmlMessageValidator = new DomXmlMessageValidator();
    private boolean autoDecode = true;

    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, ValidationContext validationContext) throws ValidationException {
        this.log.info("Start x-www-form-urlencoded message validation");
        try {
            XmlMessageValidationContext xmlMessageValidationContext = new XmlMessageValidationContext();
            DefaultMessage formMessage = new DefaultMessage(receivedMessage);
            StringResult result = new StringResult();
            this.formMarshaller.marshal(this.createFormData(receivedMessage), (Result)result);
            formMessage.setPayload((Object)result.toString());
            this.xmlMessageValidator.validateMessage((Message)formMessage, controlMessage, context, xmlMessageValidationContext);
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Failed to validate x-www-form-urlencoded message", (Throwable)e);
        }
        this.log.info("Validation of x-www-form-urlencoded message finished successfully: All values OK");
    }

    private FormData createFormData(Message message) {
        FormData formData;
        block7: {
            block6: {
                formData = new ObjectFactory().createFormData();
                formData.setContentType(this.getFormContentType(message));
                formData.setAction(this.getFormAction(message));
                if (!(message.getPayload() instanceof MultiValueMap)) break block6;
                MultiValueMap formValueMap = (MultiValueMap)message.getPayload(MultiValueMap.class);
                for (Map.Entry entry : formValueMap.entrySet()) {
                    Control control = new ObjectFactory().createControl();
                    control.setName((String)entry.getKey());
                    control.setValue(StringUtils.arrayToCommaDelimitedString((Object[])((List)entry.getValue()).toArray()));
                    formData.addControl(control);
                }
                break block7;
            }
            String rawFormData = (String)message.getPayload(String.class);
            if (!StringUtils.hasText((String)rawFormData)) break block7;
            StringTokenizer tokenizer = new StringTokenizer(rawFormData, "&");
            while (tokenizer.hasMoreTokens()) {
                Control control = new ObjectFactory().createControl();
                String[] nameValuePair = tokenizer.nextToken().split("=");
                if (this.autoDecode) {
                    try {
                        control.setName(URLDecoder.decode(nameValuePair[0], this.getEncoding()));
                        control.setValue(URLDecoder.decode(nameValuePair[1], this.getEncoding()));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new CitrusRuntimeException(String.format("Failed to decode form control value '%s=%s'", nameValuePair[0], nameValuePair[1]), (Throwable)e);
                    }
                } else {
                    control.setName(nameValuePair[0]);
                    control.setValue(nameValuePair[1]);
                }
                formData.addControl(control);
            }
        }
        return formData;
    }

    private String getEncoding() {
        return System.getProperty("citrus.file.encoding", System.getenv("CITRUS_FILE_ENCODING") != null ? System.getenv("CITRUS_FILE_ENCODING") : Charset.defaultCharset().displayName());
    }

    private String getFormAction(Message message) {
        return message.getHeader("citrus_http_request_uri") != null ? message.getHeader("citrus_http_request_uri").toString() : null;
    }

    private String getFormContentType(Message message) {
        return message.getHeader("Content-Type") != null ? message.getHeader("Content-Type").toString() : null;
    }

    public boolean supportsMessageType(String messageType, Message message) {
        return MESSAGE_TYPE.equalsIgnoreCase(messageType);
    }
}

