/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.TestAction;
import com.consol.citrus.actions.SendMessageAction;
import com.consol.citrus.dsl.actions.DelegatingTestAction;
import com.consol.citrus.dsl.builder.SendMessageBuilder;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.http.message.HttpMessageContentBuilder;
import com.consol.citrus.http.message.HttpMessageUtils;
import com.consol.citrus.message.Message;
import com.consol.citrus.validation.builder.AbstractMessageContentBuilder;
import com.consol.citrus.validation.builder.MessageContentBuilder;
import com.consol.citrus.validation.builder.StaticMessageContentBuilder;
import javax.servlet.http.Cookie;
import org.springframework.http.HttpStatus;

public class HttpServerResponseActionBuilder
extends SendMessageBuilder<SendMessageAction, HttpServerResponseActionBuilder> {
    private HttpMessage httpMessage = new HttpMessage();

    public HttpServerResponseActionBuilder(DelegatingTestAction<TestAction> delegate, Endpoint httpServer) {
        super(delegate);
        delegate.setDelegate((TestAction)new SendMessageAction());
        this.getAction().setEndpoint(httpServer);
        this.initMessage(this.httpMessage);
    }

    private void initMessage(HttpMessage message) {
        StaticMessageContentBuilder staticMessageContentBuilder = StaticMessageContentBuilder.withMessage((Message)message);
        staticMessageContentBuilder.setMessageHeaders(message.getHeaders());
        this.getAction().setMessageBuilder((MessageContentBuilder)new HttpMessageContentBuilder(message, (AbstractMessageContentBuilder)staticMessageContentBuilder));
    }

    @Override
    protected void setPayload(String payload) {
        this.httpMessage.setPayload((Object)payload);
    }

    @Override
    public HttpServerResponseActionBuilder name(String name) {
        this.httpMessage.setName(name);
        return (HttpServerResponseActionBuilder)super.name(name);
    }

    public HttpServerResponseActionBuilder status(HttpStatus status) {
        this.httpMessage.status(status);
        return this;
    }

    public HttpServerResponseActionBuilder statusCode(Integer statusCode) {
        this.httpMessage.statusCode(statusCode);
        return this;
    }

    public HttpServerResponseActionBuilder reasonPhrase(String reasonPhrase) {
        this.httpMessage.reasonPhrase(reasonPhrase);
        return this;
    }

    public HttpServerResponseActionBuilder version(String version) {
        this.httpMessage.version(version);
        return this;
    }

    public HttpServerResponseActionBuilder contentType(String contentType) {
        this.httpMessage.contentType(contentType);
        return this;
    }

    public HttpServerResponseActionBuilder cookie(Cookie cookie) {
        this.httpMessage.cookie(cookie);
        return this;
    }

    @Override
    public HttpServerResponseActionBuilder message(Message message) {
        HttpMessageUtils.copy((Message)message, (HttpMessage)this.httpMessage);
        return this;
    }
}

